package com.adobe.cq.mcm.campaign;

import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

/**
 * Interface that can be used to extend the meta data received from Adobe Campaign.
 */
public interface MetaDataExtender {

    /**
     * Extends the meta data from Adobe Campaign.
     *
     * @param root The root of the Campaign meta data that can be extended
     * @throws JSONException if the JSON could not be processed
     */
    void extend(JSONObject root) throws JSONException;

}
