package com.adobe.fontengine.font;

import java.util.Iterator;

class ComparingOutlineConsumer implements OutlineConsumer {
	Iterator compareTo;
	boolean compares = true;
	boolean hasOutlines = false;
	
	ComparingOutlineConsumer(IteratingOutlineConsumer compareTo)
	{
		this.compareTo = compareTo.iterator();
	}
	
	boolean equals() {
		return compares;
	}

	private boolean close(double first, double second)
	{
		return Math.abs(first - second) < 0.001;
	}
	
	public void curveto(double x2, double y2, double x3, double y3, double x4,
			double y4) {
		hasOutlines = true;
		
		if (!compares)
			return;
		
		if (!compareTo.hasNext()) {
			compares = false;
			return;
		}

		IteratingOutlineConsumer.Element next = (IteratingOutlineConsumer.Element)compareTo.next();
		if (next.type != IteratingOutlineConsumer.ElementType.cube) {
			compares = false;
			return;
		}
			
		if (close(x2, next.x1) && (close(y2, next.y1) && 
				close(x3, next.x2) && close(y3, next.y2) && 
				close(x4, next.x3) && close(y4, next.y3)))
			return;
		
		compares = false;
	}

	public void curveto(double x2, double y2, double x3, double y3) {
		hasOutlines = true;
		
		if (!compares)
			return;

		if (!compareTo.hasNext()) {
			compares = false;
			return;
		}
		
		IteratingOutlineConsumer.Element next = (IteratingOutlineConsumer.Element)compareTo.next();
		if (next.type != IteratingOutlineConsumer.ElementType.quad) {
			compares = false;
			return;
		}
			
		if (close(x2, next.x1) && (close(y2, next.y1) && 
				close(x3, next.x2) && close(y3, next.y2)))
			return;
		
		compares = false;

	}

	public void endchar() {
		while (compareTo.hasNext()) {
			IteratingOutlineConsumer.Element next = (IteratingOutlineConsumer.Element)compareTo.next();
			if (next.type != IteratingOutlineConsumer.ElementType.move) {
				compares = false;
				return;
			}
		}
	}
	
	private void compare1point(IteratingOutlineConsumer.ElementType type, double x, double y)
	{
		if (!compares)
			return;

		if (!compareTo.hasNext()) {
			compares = false;
			return;
		}
		
		IteratingOutlineConsumer.Element next = (IteratingOutlineConsumer.Element)compareTo.next();
		if (next.type != type) {
			compares = false;
			return;
		}
			
		if (close(x, next.x1) && (close(y, next.y1)))
			return;
		
		compares = false;
	}

	public void lineto(double x, double y) {
		hasOutlines = true;
		compare1point(IteratingOutlineConsumer.ElementType.line, x, y);
	}

	public void moveto(double x, double y) {
		compare1point(IteratingOutlineConsumer.ElementType.move, x, y);
	}

	public void setMatrix(Matrix newMatrix) {}

}
