/*
 * File: NoSuitableFontException.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.inlineformatting;

/**
 * NoSuitableFontException.
 * 
 * Thrown by inline formatters when no suitable font is found
 * to format a (portion) of a run. The definition of 
 * a suitable font depends on the formatter.
 */

public class NoSuitableFontException extends FormattingException {

  static final long serialVersionUID = 1;

  public NoSuitableFontException (int start, int limit) {
    super (start, limit);
  }

  public NoSuitableFontException (String message, int start, int limit) {
    super (message, start, limit);
  }

  public NoSuitableFontException (String message, Throwable cause, int start, int limit) {
    super (message, cause, start, limit);
  }

  public NoSuitableFontException (Throwable cause, int start, int limit) {
    super(cause, start, limit);
  }
}
