/*
 * File: TeluguFormatter.java
 * 
 *  ADOBE CONFIDENTIAL
 *  ___________________
 *
 *  Copyright 2005 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 *  NOTICE: All information contained herein is, and remains the property of
 *  Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *  and technical concepts contained herein are proprietary to Adobe Systems
 *  Incorporated and its suppliers and may be covered by U.S. and Foreign
 *  Patents, patents in process, and are protected by trade secret or
 *  copyright law. Dissemination of this information or reproduction of this
 *  material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.fontengine.inlineformatting.AttributedRun;

public class TeluguFormatter extends IndicFormatter {

  protected int splitVowelsAndNormalize (AttributedRun run, int start, int limit) {
     while (start < limit) {
      int usv = run.elementAt (start);
      switch (usv) {
        case 0x0C48: {
          run.replace (start, new int[] {0x0C46, 0x0C56});
          limit++; 
          start += 2;
          break; }
        default: {
          start++; 
          break; }}}

   return limit;
  }

  protected int nukta () {
    return -1;
  }

  protected int virama () {
    return 0xC4D;
  }

  protected boolean isConsonant (int usv) {
    return (   0xC15 <= usv && usv <= 0xC39
            || 0x25cc == usv);
  }

  protected boolean hasNukta (int usv) {
    return false;
  }

  protected int removeNukta (int usv) {
    return usv;
  }

  protected boolean isMark (int usv) {
    return (   0x0C01 <= usv && usv <= 0x0C03
            || 0x0C3E <= usv && usv <= 0xc56);
  }

  protected boolean isIndependentVowel (int usv) {
    return (   0x0C05 <= usv && usv <= 0x0C14
            || 0x25cc == usv);
  }

  protected Position getPosition (int usv) {
    switch (usv) {     
      case 0xC3E:
      case 0xC3F:
      case 0xC40:
      case 0xC46:
      case 0xC47:
      case 0xC4A:
      case 0xC4B:
      case 0xC4C: return Position.topMatra;
           
      case 0xC56: return Position.bottom;
          
      case 0xC41:
      case 0xC42:
      case 0xC43:
      case 0xC44: return Position.rightMatra;
      
      case 0xC01:
      case 0xC02:
      case 0xC03: return Position.rightOther;
      
      default:    return Position.any; }
  }
  
  protected Shape rephLike (int usv) {
    return Shape.any;
  }

  protected boolean subjoins (int usv) {
    return isConsonant (usv);
  }
  
  protected boolean postjoins (int usv) {
    return false;
  }
  
  protected boolean postjoinsIndependentVowels (int usv) {
    return false;
  }
}