/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.timeline;

import org.apache.sling.api.resource.Resource;

import java.util.Collection;

/**
 * A <code>TimelineEntryProvider</code> provides {@link TimelineEvent}s to a {@link Timeline}. Implementations must
 * register themselves as an OSGi-component and declare itself as a service on this interface. This way the timeline
 * aggregator service is able to dynamically use available providers to generate timline events for a given {@link
 * Resource}. A provider may decide (see {@link #accepts(org.apache.sling.api.resource.Resource)}) whether to provide
 * events or not for a given resource. Events are provided via {@link #getEvents(org.apache.sling.api.resource.Resource)}.
 */
public interface TimelineEventProvider {

    /**
     * Indicates to the timeline aggregator whether this provider accepts the given <code>resource</code> or not. In
     * case the provider doesn not accept the resource, {@link #getEvents(org.apache.sling.api.resource.Resource)} is
     * never called.
     *
     * @param resource The {@link Resource} to indicate for whether it is accepted or not.
     *
     * @return <code>true</code> if the provider accepts providing events for the given resource.
     */
    boolean accepts(Resource resource);

    /**
     * If {@link #accepts(org.apache.sling.api.resource.Resource)} returns <code>true</code> for a given resource, this
     * method is called with the same resource parameter in order for the provider to return a <code>Collection</code>
     * of {@link TimelineEvent}s for the given resource.
     *
     * @param resource The {@link Resource} for which to return {@link TimelineEvent}s.
     *
     * @return A {@link Collection} of {@link TimelineEvent}s or an empty collection if the provider did not
     *         find/generate any events.
     */
    Collection<TimelineEvent> getEvents(Resource resource);

    /**
     * Returns the {@link TimelineEventType} this provider provides.
     *
     * @return The {@link TimelineEventType}.
     */
    TimelineEventType getType();
}
