/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.ui.clientlibs.script;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;

import javax.annotation.Nonnull;

import org.osgi.annotation.versioning.ConsumerType;
import com.adobe.granite.ui.clientlibs.HtmlLibrary;

/**
 * {@code ScriptTransformer} is an extension to the script processor which operates on script collections.
 */
@ConsumerType
public interface ScriptTransformer extends ScriptProcessor {

    /**
     * Processes the given input using the options.
     *
     * @param library the library that is processed
     * @param sources input sources
     * @param options processing options.
     * @return The processed sources or {@code sources} if not modified.
     * @throws IOException if an I/O error occurs
     */
    @Nonnull
    Collection<ScriptResource> process(@Nonnull HtmlLibrary library, @Nonnull Collection<ScriptResource> sources,
                                       @Nonnull Map<String, String> options)
            throws IOException;
}