/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.metadata;

import java.util.Map;

/**
 * A value map for generic access to meta data values.
 * 
 */
public interface MetaDataMap extends Map<String, Object> {

    /**
     * Get a meta data property and make an attempt to convert it into the given
     * type.
     * 
     * @param name
     *            The name of the meta data property
     * @param type
     *            The class of the type to use for conversion.
     * @param <T> the type of the class
     * @return The value of the property converted to type T or
     *         <code>null</code> if there is no such property or it cannot be
     *         converted to the given type.
     */
    <T> T get(String name, Class<T> type);

    /**
     * Get a meta data property and make an attempt to convert it into the given
     * type.
     * 
     * @param name
     *            The name of the meta data property
     * @param defaultValue
     *            A default value to use in case the property does not exist or
     *            cannot be converted. The type to convert to is determined by
     *            the type of the default value. If the default value is
     *            <code>null</code> and a property for the given name exists, it
     *            is returned without conversion.
     * @param <T> the type of the class
     * @return The value of the property converted to type T or
     *         <code>null</code> if there is no such property or it cannot be
     *         converted to the given type.
     */
    <T> T get(String name, T defaultValue);

}
