/**
 * 
 */
package com.adobe.internal.io;

import java.io.IOException;

/**
 * Wraps a ByteWriter and makes it appear to start from the offset given
 * during construction.
 */
public class RangedByteWriter extends FilterByteWriter
{

	private final long start;

	/**
	 * Constructor
	 * 
	 * @param byteWriter the original ByteWriter
	 * @param offset the offset in the original ByteWriter
	 */
	public RangedByteWriter(ByteWriter byteWriter, long offset)
	{
		super(byteWriter);
		this.start = offset;
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.FilterByteWriter#length()
	 */
	public long length() throws IOException
	{
		return Math.max(super.length() - this.start, 0);
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.FilterByteWriter#read(long, byte[], int, int)
	 */
	public int read(long position, byte[] b, int offset, int length) throws IOException
	{
		return super.read(position + this.start, b, offset, length);
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.FilterByteWriter#read(long)
	 */
	public int read(long position) throws IOException
	{
		return super.read(position + this.start);
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.FilterByteWriter#write(long, byte[], int, int)
	 */
	public void write(long position, byte[] b, int offset, int length) throws IOException
	{
		super.write(position + this.start, b, offset, length);
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.FilterByteWriter#write(long, int)
	 */
	public void write(long position, int b) throws IOException
	{
		super.write(position + this.start, b);
	}

}
