package com.adobe.internal.io.stream;

import java.io.IOException;
import java.io.InputStream;

public interface InputByteStream
{

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * The value is returned as a marker for the End Of File from the get() methods.
	 */
	public static final int EOF = -1;

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * Create a new <code>InputByteStream</code> that that provides another view on the underlying
	 * data.  This new <code>InputByteStream</code> is completely independent and can be read from
	 * and positioned without affecting the original or any other <i>slice</i>
	 * <code>InputByteStream</code> objects.  The initial position of the <i>slice</i> is at zero -
	 * the beginning of the <i>slice</i>.
	 * @param begin	Offset within the current <code>InputByteStream</code> to start the <i>slice</i>.
	 * @param length	The length of the <i>slice</i>.
	 * @return A <i>slice</i> of the original <code>InputByteStream</code>.
	 * @throws IOException
	 */
	InputByteStream slice(long begin, long length)
	throws IOException;

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * Create a new <code>InputByteStream</code> that that provides another view on the underlying
	 * data.  This new <code>InputByteStream</code> is completely independent and can be read from
	 * and positioned without affecting the original or any other <i>slice</i>
	 * <code>InputByteStream</code> objects.  The initial position of the <i>slice</i> is at zero -
	 * the beginning of the <i>slice</i>.  The <i>slice</i> has the same bounds as the original
	 * <code>InputByteStream</code>.
	 *
	 * One common but probably incorrect usage of this method is to create a temporary "view"
	 * on the data that is used briefly within a method and then discarded.  This is pretty
	 * wasteful and creates a number of small objects.  In that case it would be better
	 * to find the current position using <code>getPosition()</code> and store it locally
	 * in the method and then restore the position with <code>setPosition()</code>
	 * before returning from the method.
	 * @return A <i>slice</i> of the original <code>InputByteStream</code>.
	 * @throws IOException
	 */
	InputByteStream slice()
	throws IOException;

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * Read the byte at the current position.  If the current position is at or beyond
	 * the end of the underlying data return a <code>-1</code>.  If not beyond the end
	 * of the underlying data the current position is incremented by 1.
	 * @return The byte at the current position or <code>-1</code> if at or beyond EOF.
	 * @throws IOException
	 */
	int read()
	throws IOException;

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * Read an array of bytes starting at the current  position. The
	 * position is incremented by the length of the array that has been read.
	 * @param bytes	The destination array.
	 * @param position	The offset in the byte array to put the first byte read.
	 * @param length	 The number of bytes to read.
	 * @throws IOException
	 */
	int read(byte[] bytes, int position, int length)
	throws IOException;

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * Read an array of bytes starting at the current  position. The
	 * position is incremented by the length of the array that has been read.
	 * @param bytes	The destination array.
	 * @throws IOException
	 */
	int read(byte[] bytes)
	throws IOException;

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * "Unget" the byte from underlying data.  This essentially returns the byte
	 * just before the current position and sets the current position to point
	 * at that byte (one before the current position).
	 * @throws IOException
	 */
	int unget()
	throws IOException;

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * Set the current position in the underlying data.  This position is pegged
	 * to be no less than zero and no greater than the length of the InputByteStream.
	 * @param position Where to set the current position.
	 * @return This object.
	 * @throws IOException
	 */
	InputByteStream seek(long position)
	throws IOException;

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * Get the current position.
	 * @return The current position.
	 * @throws IOException
	 */
	long getPosition()
	throws IOException;

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * The maximum number of bytes that can be read from this <code>InputByteStream</code>.
	 *
	 * @return Total number of bytes available in this <code>InputByteStream</code>.
	 * @throws IOException
	 */
	long length()
	throws IOException;

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * The number of bytes available to be read from the current position.
	 * @return Number of bytes available from the current position in this <code>InputByteStream</code>.
	 * @throws IOException
	 */
	long bytesAvailable()
	throws IOException;

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * Is the current position of this <code>InputByteStream</code> at or beyond the
	 * end of the underlying data.
	 * @return True if the current position is beyond the end of the underlying data, false otherwise.
	 * @throws IOException
	 */
	boolean eof()
	throws IOException;

	/**
	 * Closes this InputByteStream and releases any system resources associated with the stream.
	 * After this method is called then any further calls to this instance are errors.
	 * @throws IOException
	 */
	void close()
	throws IOException;

	/**
	 * Create an InputStream that represents the same data as this InputByteStream.
	 * The new InputStream is independent of the InputByteStream and operations on 
	 * one will not affect the other including closing of either stream.
	 * @return an InputStream that refers to the same underlying data
	 * @throws IOException
	 */
	InputStream toInputStream()
	throws IOException;

}
