/* ****************************************************************************
 *
 *	File: CosArrayValuesIterator.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

// @author itenenbo

package com.adobe.internal.pdftoolkit.core.cos;

import java.io.IOException;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;


public class CosArrayValuesIterator extends CosContainerValuesIterator
{

	private CosObject[] mValues;
	int mInd;
	
	public CosArrayValuesIterator(CosObject[] values)
	{
		mValues = values;
		mInd = 0;
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator#hasNext()
	 */
	@Override
	public boolean hasNext()
	{
		return mInd < mValues.length; 
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator#next()
	 */
	@Override
	public Entry next()
	throws PDFCosParseException, PDFIOException, PDFSecurityException
	{
		try {
			CosObject curObj = mValues[mInd++];
			if (curObj instanceof CosObjectRef)
			{
				curObj = curObj.getDocument().resolveReference((CosObjectRef) curObj);
			}
			return createEntry(null, mInd, curObj);
		} catch(IOException e) {
			throw new PDFIOException(e);
		}
	}

}
