/* $Header: /Faultline/com/adobe/acrobat/filters/CCITTFaxTables.java 1   */
/*
  CCITTFaxTables.java

  (C) Copyright 1996 Adobe Systems Inc.  All rights reserved.

  Modification log:
    12/10/96 McCreight -- initial version.
*/

package com.adobe.internal.pdftoolkit.core.filter;

public interface CCITTFaxTables {
  public static final byte byteReverse[] =
  {
      (byte) 0x00, (byte) 0x80, (byte) 0x40, (byte) 0xC0,
      (byte) 0x20, (byte) 0xA0, (byte) 0x60, (byte) 0xE0,
      (byte) 0x10, (byte) 0x90, (byte) 0x50, (byte) 0xD0,
      (byte) 0x30, (byte) 0xB0, (byte) 0x70, (byte) 0xF0,
      (byte) 0x08, (byte) 0x88, (byte) 0x48, (byte) 0xC8,
      (byte) 0x28, (byte) 0xA8, (byte) 0x68, (byte) 0xE8,
      (byte) 0x18, (byte) 0x98, (byte) 0x58, (byte) 0xD8,
      (byte) 0x38, (byte) 0xB8, (byte) 0x78, (byte) 0xF8,
      (byte) 0x04, (byte) 0x84, (byte) 0x44, (byte) 0xC4,
      (byte) 0x24, (byte) 0xA4, (byte) 0x64, (byte) 0xE4,
      (byte) 0x14, (byte) 0x94, (byte) 0x54, (byte) 0xD4,
      (byte) 0x34, (byte) 0xB4, (byte) 0x74, (byte) 0xF4,
      (byte) 0x0C, (byte) 0x8C, (byte) 0x4C, (byte) 0xCC,
      (byte) 0x2C, (byte) 0xAC, (byte) 0x6C, (byte) 0xEC,
      (byte) 0x1C, (byte) 0x9C, (byte) 0x5C, (byte) 0xDC,
      (byte) 0x3C, (byte) 0xBC, (byte) 0x7C, (byte) 0xFC,
      (byte) 0x02, (byte) 0x82, (byte) 0x42, (byte) 0xC2,
      (byte) 0x22, (byte) 0xA2, (byte) 0x62, (byte) 0xE2,
      (byte) 0x12, (byte) 0x92, (byte) 0x52, (byte) 0xD2,
      (byte) 0x32, (byte) 0xB2, (byte) 0x72, (byte) 0xF2,
      (byte) 0x0A, (byte) 0x8A, (byte) 0x4A, (byte) 0xCA,
      (byte) 0x2A, (byte) 0xAA, (byte) 0x6A, (byte) 0xEA,
      (byte) 0x1A, (byte) 0x9A, (byte) 0x5A, (byte) 0xDA,
      (byte) 0x3A, (byte) 0xBA, (byte) 0x7A, (byte) 0xFA,
      (byte) 0x06, (byte) 0x86, (byte) 0x46, (byte) 0xC6,
      (byte) 0x26, (byte) 0xA6, (byte) 0x66, (byte) 0xE6,
      (byte) 0x16, (byte) 0x96, (byte) 0x56, (byte) 0xD6,
      (byte) 0x36, (byte) 0xB6, (byte) 0x76, (byte) 0xF6,
      (byte) 0x0E, (byte) 0x8E, (byte) 0x4E, (byte) 0xCE,
      (byte) 0x2E, (byte) 0xAE, (byte) 0x6E, (byte) 0xEE,
      (byte) 0x1E, (byte) 0x9E, (byte) 0x5E, (byte) 0xDE,
      (byte) 0x3E, (byte) 0xBE, (byte) 0x7E, (byte) 0xFE,
      (byte) 0x01, (byte) 0x81, (byte) 0x41, (byte) 0xC1,
      (byte) 0x21, (byte) 0xA1, (byte) 0x61, (byte) 0xE1,
      (byte) 0x11, (byte) 0x91, (byte) 0x51, (byte) 0xD1,
      (byte) 0x31, (byte) 0xB1, (byte) 0x71, (byte) 0xF1,
      (byte) 0x09, (byte) 0x89, (byte) 0x49, (byte) 0xC9,
      (byte) 0x29, (byte) 0xA9, (byte) 0x69, (byte) 0xE9,
      (byte) 0x19, (byte) 0x99, (byte) 0x59, (byte) 0xD9,
      (byte) 0x39, (byte) 0xB9, (byte) 0x79, (byte) 0xF9,
      (byte) 0x05, (byte) 0x85, (byte) 0x45, (byte) 0xC5,
      (byte) 0x25, (byte) 0xA5, (byte) 0x65, (byte) 0xE5,
      (byte) 0x15, (byte) 0x95, (byte) 0x55, (byte) 0xD5,
      (byte) 0x35, (byte) 0xB5, (byte) 0x75, (byte) 0xF5,
      (byte) 0x0D, (byte) 0x8D, (byte) 0x4D, (byte) 0xCD,
      (byte) 0x2D, (byte) 0xAD, (byte) 0x6D, (byte) 0xED,
      (byte) 0x1D, (byte) 0x9D, (byte) 0x5D, (byte) 0xDD,
      (byte) 0x3D, (byte) 0xBD, (byte) 0x7D, (byte) 0xFD,
      (byte) 0x03, (byte) 0x83, (byte) 0x43, (byte) 0xC3,
      (byte) 0x23, (byte) 0xA3, (byte) 0x63, (byte) 0xE3,
      (byte) 0x13, (byte) 0x93, (byte) 0x53, (byte) 0xD3,
      (byte) 0x33, (byte) 0xB3, (byte) 0x73, (byte) 0xF3,
      (byte) 0x0B, (byte) 0x8B, (byte) 0x4B, (byte) 0xCB,
      (byte) 0x2B, (byte) 0xAB, (byte) 0x6B, (byte) 0xEB,
      (byte) 0x1B, (byte) 0x9B, (byte) 0x5B, (byte) 0xDB,
      (byte) 0x3B, (byte) 0xBB, (byte) 0x7B, (byte) 0xFB,
      (byte) 0x07, (byte) 0x87, (byte) 0x47, (byte) 0xC7,
      (byte) 0x27, (byte) 0xA7, (byte) 0x67, (byte) 0xE7,
      (byte) 0x17, (byte) 0x97, (byte) 0x57, (byte) 0xD7,
      (byte) 0x37, (byte) 0xB7, (byte) 0x77, (byte) 0xF7,
      (byte) 0x0F, (byte) 0x8F, (byte) 0x4F, (byte) 0xCF,
      (byte) 0x2F, (byte) 0xAF, (byte) 0x6F, (byte) 0xEF,
      (byte) 0x1F, (byte) 0x9F, (byte) 0x5F, (byte) 0xDF,
      (byte) 0x3F, (byte) 0xBF, (byte) 0x7F, (byte) 0xFF
  };
  public static final byte runTab0[] =
  {
      // Low-order 4 bits are length of leading run of 0's.
      // High-order 4 bits are index of highest-order run of
      //   five consecutive 0's:
      //   00000xxx  => 1
      //   100000xx  => 2
      //   x100000x  => 3
      //   xx100000  => 4
      //   otherwise => 0
      0x18, 0x17, 0x16, 0x16, 0x15, 0x15, 0x15, 0x15,
      0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
      0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
      0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
      0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
      0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
      0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
      0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
      0x31, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
      0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
      0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
      0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
      0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
      0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
      0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
      0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
      0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };

  /* One-dimensional codes: */
  public static final byte TERM_CODES = 64;
  public static final byte MAKE_UP_CODES = 40;
  public static final byte EOLP = (byte)(TERM_CODES + MAKE_UP_CODES);
          // End Of Line prefix (104)
  public static final byte UNCW = (byte)(EOLP + 1);
          // to/from Uncompressed Mode (white next) (105)
  public static final byte UNCB = (byte)(UNCW + 1);
          // to/from Uncompressed Mode (black next) (106)
  public static final byte UND = (byte)(UNCB + 1); // Undefined (107)
  public static final byte EXT = (byte)(UND + 1); // first extension (108)

  /* Two-dimensional codes (at the top end of the make-up codes) */
  public static final byte VL3_2D = (byte)(TERM_CODES + MAKE_UP_CODES - 9); /* 95 */
  public static final byte VL2_2D = (byte)(VL3_2D + 1); /* 96 */
  public static final byte VL1_2D = (byte)(VL2_2D + 1); /* 97 */
  public static final byte V0_2D = (byte)(VL1_2D + 1); /* 98 */
  public static final byte VR1_2D = (byte)(V0_2D + 1); /* 99 */
  public static final byte VR2_2D = (byte)(VR1_2D + 1); /* 100 */
  public static final byte VR3_2D = (byte)(VR2_2D + 1); /* 101 */
  public static final byte P_2D = (byte)(VR3_2D + 1); /* 102 */
  public static final byte H_2D = (byte)(P_2D + 1); /* 103 */

  /* Make-up uncompressed codes */
  public static final byte W5_U = (byte)(TERM_CODES + MAKE_UP_CODES - 1); /* 103 */
  public static final byte B11_U = (byte)(TERM_CODES + MAKE_UP_CODES - 1); /* 103 */

  /* Table indexes for codes longer than 8 bits */
  public static final byte XDT = (byte)(UND + 1); /* 108 */


  public static final int BASE_WHITE = 0;
  public static final int BASE_BLACK = XDT;
  public static final int BASE_U_WHITE = BASE_BLACK + XDT;
  public static final int BASE_U_BLACK = BASE_U_WHITE + 12;
  public static final int BASE_2D = BASE_U_BLACK + 12 - VL3_2D;

  public static final short encode[] = {
      /*
         The low-order 4 bits give the length of the code in bits.
         The next 11 bits give the code.  If the code length is less than
          11 bits, the code is left-aligned in the field.  If the code
          length is greater than 11, the field is the low-order 11 bits of
          the code, and the high-order bits are 0.
         The high-order bit is ignored.
      */

      /* White 1-D codes */
      0x1A88, 0x0E06, 0x3804, 0x4004, 0x5804, 0x6004, 0x7004, 0x7804,
      0x4C05, 0x5005, 0x1C05, 0x2005, 0x1006, 0x0606, 0x6806, 0x6A06,
      0x5406, 0x5606, 0x2707, 0x0C07, 0x0807, 0x1707, 0x0307, 0x0407,
      0x2807, 0x2B07, 0x1307, 0x2407, 0x1807, 0x0108, 0x0188, 0x0D08,
      0x0D88, 0x0908, 0x0988, 0x0A08, 0x0A88, 0x0B08, 0x0B88, 0x1408,
      0x1488, 0x1508, 0x1588, 0x1608, 0x1688, 0x0208, 0x0288, 0x0508,
      0x0588, 0x2908, 0x2988, 0x2A08, 0x2A88, 0x1208, 0x1288, 0x2C08,
      0x2C88, 0x2D08, 0x2D88, 0x2508, 0x2588, 0x1908, 0x1988, 0x1A08,
      0x6C05, 0x4805, 0x2E06, 0x3707, 0x1B08, 0x1B88, 0x3208, 0x3288,
      0x3408, 0x3388, 0x3309, 0x3349, 0x3489, 0x34C9, 0x3509, 0x3549,
      0x3589, 0x35C9, 0x3609, 0x3649, 0x3689, 0x36C9, 0x2609, 0x2649,
      0x2689, 0x3006, 0x26C9, 0x008B, 0x00CB, 0x00DB, 0x012C, 0x013C,
      0x014C, 0x015C, 0x016C, 0x017C, 0x01CC, 0x01DC, 0x01EC, 0x01FC,
      0x000B, 0x00FC, 0x00FC, 0x0000,
      /* Black 1-D codes */
      0x06EA, 0x2003, 0x6002, 0x4002, 0x3003, 0x1804, 0x1004, 0x0C05,
      0x0A06, 0x0806, 0x0407, 0x0507, 0x0707, 0x0208, 0x0388, 0x0609,
      0x02EA, 0x030A, 0x010A, 0x067B, 0x068B, 0x06CB, 0x037B, 0x028B,
      0x017B, 0x018B, 0x0CAC, 0x0CBC, 0x0CCC, 0x0CDC, 0x068C, 0x069C,
      0x06AC, 0x06BC, 0x0D2C, 0x0D3C, 0x0D4C, 0x0D5C, 0x0D6C, 0x0D7C,
      0x06CC, 0x06DC, 0x0DAC, 0x0DBC, 0x054C, 0x055C, 0x056C, 0x057C,
      0x064C, 0x065C, 0x052C, 0x053C, 0x024C, 0x037C, 0x038C, 0x027C,
      0x028C, 0x058C, 0x059C, 0x02BC, 0x02CC, 0x05AC, 0x066C, 0x067C,
      0x01EA, 0x0C8C, 0x0C9C, 0x05BC, 0x033C, 0x034C, 0x035C, 0x06CD,
      0x06DD, 0x04AD, 0x04BD, 0x04CD, 0x04DD, 0x072D, 0x073D, 0x074D,
      0x075D, 0x076D, 0x077D, 0x052D, 0x053D, 0x054D, 0x055D, 0x05AD,
      0x05BD, 0x064D, 0x065D, 0x008B, 0x00CB, 0x00DB, 0x012C, 0x013C,
      0x014C, 0x015C, 0x016C, 0x017C, 0x01CC, 0x01DC, 0x01EC, 0x01FC,
      0x000B, 0x00FC, 0x00FC, 0x0000,
      /* Entwined uncompressed white, uncompressed black, and 2-D codes */
      0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0206, 0x0207, 0x0208,
      0x0209, 0x020A, 0x041C, 0x082D, 0x0000, 0x4001, 0x6002, 0x7003,
      0x7804, 0x7C05, 0x7E06, 0x7F07, 0x7F88, 0x7FC9, 0x7FEA, 0x7FFB,
      0x0207, 0x0406, 0x2003, 0x4001, 0x3003, 0x0606, 0x0307, 0x0804,
      0x1003, 0x000B, 0x01EA, 0x01EA, 0x0000, 0x0000, 0x0000, 0x0000,
      0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
      0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
      0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
      0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
      0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
      0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
      0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
      0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0206,
      0x000B, 0x0108, 0x0188, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
      0x0000, 0x0000, 0x0000, 0x7FFB, 0x000B, 0x0108, 0x0188, 0x0000
  };
}