/* ****************************************************************************
 *
 *	File: ImageFilterInterface.java
 *
 * ****************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *   Copyright 2010 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.

 * ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.filter.spi;

import java.io.IOException;
import java.io.InputStream;


/**
 * This interface is written mainly for JPXDecode filter scenario where image information is embedded inside encoded image
 * stream itself. We need to return this information to PDFXObjectImage object which will be set in it's dictionary.
 * @author hkansal
 *
 */
public interface ImageFilterInterface extends CustomDecodeFilter{
	
	/**
	 * returns image information (bit depth and number of color components).
	 * @param input
	 * @return ImageInfo
	 * @throws IOException
	 */
	public ImageInfo getImageInfo(InputStream input) throws IOException;
	
	/**
	 * This class acts as a container for image bit depth and number of color components.
	 * @author hkansal
	 *
	 */
	public static class ImageInfo{
		private int bitDepth = -1;
		private int numberOfColorComponents = -1;
		
		/**
		 * returns bit depth
		 * @return int
		 */
		public int getBitDepth(){
			return bitDepth;
		}
		
		/**
		 * sets bit depth
		 * @param bitDepth
		 */
		public void setBitDepth(int bitDepth){
			this.bitDepth = bitDepth;
		}
		
		/**
		 * returns number of color components.
		 * @return int
		 */
		public int getNumberOfColorComponents(){
			return numberOfColorComponents;
		}
		
		/**
		 * sets number of color components.
		 * @param numberOfColorComponents
		 */
		public void setNumberOfColorComponents(int numberOfColorComponents){
			this.numberOfColorComponents = numberOfColorComponents;
		}
	}
	
}