/* File: PKCS7EnvelopedDataHandler.java
*  
* ****************************************************************************
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2006 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
* ***************************************************************************/

// @author itenenbo

package com.adobe.internal.pdftoolkit.core.securityframework;

import java.util.Map;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;

public interface PKCS7EnvelopedDataHandler
{
	
	/**
	 * <P>This API takes the credentials and encrypt parameters using which it encrypts enveloped data.
	 * It creates the enveloped data packet which has all the information and encrypted data and encrypted key.
	 * This enveloped data is being returned.
	 * </P>
	 * @param credentials
	 * @param envelopedData
	 * @param encryptParams
	 * @return byte[]
	 * @throws Exception
	 */
	byte[] buildPKCS7EnvelopedData(Credentials[] credentials, byte[] envelopedData, Map encryptParams)
	throws Exception;
	
	
	/**
	 * <P>This API takes the credentials and encrypted enveloped data packet.
	 * Using the information stored in the packet and credentials decrypt the enveloped data 
	 * and returns the decrypted data. 
	 * </P>
	 * @param recipient
	 * @param pkcs7
	 * @return byte[] 
	 * @throws Exception
	 */
	byte[] getEnvelopeData(Credentials recipient, byte[] pkcs7)
	throws Exception;	
}
