package com.adobe.internal.pdftoolkit.core.util;

public class UTFSupport {

	static public final String UTF16 = "UTF-16";
	static public final String UTF8 = "UTF-8";

	
	protected static byte[] trimTrailingZeros(byte[] bytes, boolean utf16)
	{
		int length = bytes.length;
		// Trim trailing zeros
		while ((length > 0) && (bytes[length - 1] == 0))
			{
				length--;
			}
		if (bytes.length == length)
			return bytes;
		else
			{
				byte[] returnBytes = new byte[length];
				System.arraycopy(bytes, 0, returnBytes, 0, length);
				return returnBytes;
			}

	}
	
}
