/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2006, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be coveredby   */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/

package com.adobe.versioncue.nativecomm.io;

import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.msg.INCExternalizable;
import com.adobe.versioncue.nativecomm.msg.NCMap;
import com.adobe.versioncue.nativecomm.msg.NCType;

/**
 * @author <a href="mailto:tnaroska@adobe.com">tnaroska</a>
 * @version $Revision: #1 $
 * @since Mar 5, 2006
 */
public interface IConnection
{
	/** Start a transaction on this connection */
	void beginTransaction();

	/**
	 * Reads an NCType message object from this connection.
	 * 
	 * @param timeout - timeout in milliseconds
	 * @return the read NCType object
	 * @throws NativeCommException
	 *             on error
	 */
	NCType read(int timeout) throws NativeCommException;

	/**
	 * Serializes an NCType over this connection.
	 * 
	 * @param message - externalizable message object to send
	 * @param timeout - timeout in milliseconds
	 * @throws NativeCommException on error
	 */
	void write(INCExternalizable message, int timeout) throws NativeCommException;

	/** End a transaction on this connection */
	void endTransaction();

	/** @return true if this instance is ready to execute further requests */
	boolean isValid();

	/** @return the handshake dictionary */
	NCMap handshake();

	/** Dispose the connection. */
	void dispose();

	/** Invalidate the connection.
	 * Marks the connection for future disposal, but does not cancel currently running requests.
	 */
	void invalidate();
}
