/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2001-2002, Adobe Systems Incorporated                        */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/
package com.adobe.versioncue.nativecomm.msg;

/**
 * @author <a href="mailto:tnaroska@adobe.com">Timo Naroska</a>
 * @version $Revision: #1 $
 */
public final class NCNull extends NCType
{
	// ---------------------------------------------------------------------------- Public Constants

	/** Singleton instance */
	public static final NCNull INSTANCE = new NCNull();

	// ------------------------------------------------------------------------- Private Constructor

	/** Private constructor */
	private NCNull()
	{
		// empty
	}

	// ------------------------------------------------------------------------------ Public Methods

	@Override
	public int getType()
	{
		return TYPE_NULL;
	}

	@Override
	public int hashCode()
	{
		return System.identityHashCode(this);
	}

	@Override
	public boolean equals(Object other)
	{
		return other == this;
	}

	@Override
	public String toString()
	{
		return "NCNull";
	}
}
