/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2001-2002, Adobe Systems Incorporated                        */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/
package com.adobe.versioncue.nativecomm.msg;

/**
 * @author <a href="mailto:tnaroska@adobe.com">Timo Naroska</a>
 * @version $Revision: #1 $
 */
public final class NCString extends NCType
{
	// --------------------------------------------------------------------------- Private Variables

	/** String value */
	private final String value;

	// -------------------------------------------------------------------------- Public Constructor

	/**
	 * Create a <code>NCString</code> instance.
	 * 
	 * @param value String value of the created instance
	 */
	public NCString(String value)
	{
		// == PRE-CONDITION ========================================================================
		if (value == null)
			throw new NullPointerException("value can't be null");
		// == PRE-CONDITION ========================================================================

		this.value = value;
	}

	// ------------------------------------------------------------------------------ Public Methods

	/**
	 * Returns the String value of this object
	 * 
	 * @return String value of this object
	 */
	public String string()
	{
		return value;
	}

	@Override
	public int getType()
	{
		return TYPE_STRING;
	}

	@Override
	public int hashCode()
	{
		return value.hashCode();
	}

	@Override
	public boolean equals(Object other)
	{
		if (other != null && other instanceof NCString)
		{
			NCString otherString = (NCString) other;
			return value.equals(otherString.value);
		}
		return false;
	}

	@Override
	public String toString()
	{
		return "NCString <" + value + ">";
	}
}
