/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.formcalc;


/**
 * Class <b>ProtocolHost</b> defines the interface by which the
 * {@link CalcParser} (FormCalc scripting engine) can access
 * a protocol host whenever it needs to get/put/post url datas.
 *
 * <p> FormCalc applications need to inform the FormCalc script engine
 * that they are capable of supporting the ProtocolHost
 * interface by invoking the 
 * {@link CalcParser#setProtocolHost(ProtocolHost)}
 * method. 
 *
 * @author Mike Tardif
 * 
 * @exclude from published api.
 */
public interface ProtocolHost {

    /**
     * Abstract method to get data from an URL.
	 *
	 * @param sUrl the URL to get.
	 *
	 * @return a returned CalcSymbol value upon success.
	 *
	 * @throws {@link CalcException}
	 * upon error or catatrophic failure.
	 */
    CalcSymbol getUrl(String sUrl) throws CalcException;

    /**
     * Abstract method to put data to an URL.
	 *
	 * @param sUrl the URL to put.
	 *
	 * @param sData the data to put.
	 *
	 * @param sEnc the encoding to use.
	 *
	 * @return a returned CalcSymbol value upon success.
	 *
	 * @throws {@link CalcException}
	 * upon error or catatrophic failure.
	 */
    CalcSymbol putUrl(String sUrl, String sData, String sEnc)
											throws CalcException;

    /**
     * Abstract method to post data to an URL and get its response.
	 *
	 * @param sUrl the URL to post.
	 *
	 * @param sSoapHeader an optional post header.
	 *
	 * @param sData the data to post.
	 *
	 * @param sEnc the encoding to use.
	 *
	 * @return a returned CalcSymbol value upon success.
	 *
	 * @return 0 upon success.
	 *
	 * @throws {@link CalcException}
	 * upon error or catatrophic failure.
	 */
    CalcSymbol postUrl(String sUrl, String sSoapHeader, 
							String sData, String sContentType, String sEnc)
											throws CalcException;


}
