
//----------------------------------------------------------------------
//
// File: mkembed.h
//
// Description
//	Public header file for class MkEmbed
//
//		This is a class that helps enumerate embedded objects in a
//		stream It uses the markup translation framework, saving
//		only pointers to embedded objects encountered.
//
// Change history
//	Project 	Release Date	Who 	Review	What
//	HawaiiRd	5.0 	951006	RD				Created.
//
//----------------------------------------------------------------------

package com.adobe.xfa.text.markup;

import java.util.List;

import com.adobe.xfa.text.TextEmbed;


/**
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public class MarkupEmbed extends MarkupOut {
	private final List<TextEmbed> mpoEmbedOut;

	MarkupEmbed (List<TextEmbed> poEmbedOut) {
		mpoEmbedOut = poEmbedOut;
		mpoEmbedOut.clear();
	}

// Inherited from class TextMkOut.
	public void embed (TextEmbed poEmbed) {
		mpoEmbedOut.add (poEmbed);
	}

	public boolean suppressAttributes () {
		return true;
	}
}
