/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2008 Adobe Systems Incorporated
 * All Rights Reserved
 *
 * Notice: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa.wspolicy;

import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;

/**
 * @exclude from published api.
 */
public class PrimitiveAssertion extends Policy {

	PrimitiveAssertion (Document oDestDoc, Element oSrcNode) {
		super (oDestDoc, oSrcNode);
		setAssertionType (Policy.WSP_PRIMITIVE_ASSERTION); // defaults to this, but just to be sure...

		for (Node oChild = oSrcNode.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
			if (oChild instanceof Element) {
				Element e = (Element) oChild;
				if (isPolicyOrRef (e)) {
					Policy poChildPolicy = Policy.loadPolicy (oDestDoc, e);
					if (poChildPolicy != null) {
						addPolicy (poChildPolicy);
					}
	
					break; // WS-Policy spec allows only a single nested policy
				}
			}
		}
	}

	PrimitiveAssertion (Document oDestDoc, String aNameSpaceURI, String aLocalName) {
		super (oDestDoc, aNameSpaceURI, aLocalName);
		setAssertionType (Policy.WSP_PRIMITIVE_ASSERTION); // defaults to this, but just to be sure...
	}

// Fetches a nested <wsp:Policy> element.  This must be a singleton.
	public boolean hasNestedPolicy () {
		return getFirstPolicyChild() != null;
	}

	public CompoundAssertion getNestedPolicy () {
		Policy policy = getFirstPolicyChild();
		if (policy != null) {
			assert (policy instanceof CompoundAssertion);
			return (CompoundAssertion) policy;
		}
		return null;
	}

// Adds a new nested <wsp:Policy>
	public CompoundAssertion addNestedPolicy () {
		if (!hasNestedPolicy()) {
			Document oDoc = getDomNode().getOwnerDocument();
			CompoundAssertion poPolicy = new CompoundAssertion (oDoc, aWSP_NAMESPACE_URI, aWSP_POLICY);
			addPolicy (poPolicy);
		}
		return getNestedPolicy();
	}
}
