/*
 * File: Context.java
 * ************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.xmp.schema.rng.model;

import com.adobe.xmp.schema.rng.parser.SchemaGenerationHandler;

/**
 * The input schema definition file can define multiple XMP schemas. Each of those schemas defines multiple properties.
 * The context stores an information holder for current property and current schema.
 * 
 * @author hraghav
 */
public class Context
{
	/**
	 * This objects stores information such as namespace, label etc for current schema
	 */
	private SchemaInfo currentSchemaInfo;

	private SchemaGenerationHandler handler;

	/**
	 * Constructs a new Context.
	 */
	public Context()
	{
		this.currentSchemaInfo = new SchemaInfo();
	}

	/**
	 * Gets current SchemaInfo object
	 * 
	 * @return SchemaInfo
	 */
	public SchemaInfo getCurrentSchemaInfo()
	{
		return this.currentSchemaInfo;
	}

	/**
	 * Sets current SchemaInfo object
	 * 
	 * @param schemaInfo
	 *            SchemaInfo object to set
	 */
	public void setCurrentSchemaInfo(SchemaInfo schemaInfo)
	{
		this.currentSchemaInfo = schemaInfo;
	}

	/**
	 * @return ISchemaGenerationTraceHandler registered to handle callbacks
	 */
	public SchemaGenerationHandler getSchemaGenerationHandler()
	{
		return this.handler;
	}

	/**
	 * Registers ISchemaGenerationTraceHandler for callbacks
	 * 
	 * @param handler
	 *            ISchemaGenerationTraceHandler to set
	 */
	public void setSchemaGenerationHandler(SchemaGenerationHandler handler)
	{
		this.handler = handler;
	}
}
