/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2006 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.commons.datasource.poolservice;

/** Indicates that the required type of data source
 *  is not available.
 */
@SuppressWarnings("serial")
public class TypeNotAvailableException extends Exception {
    public TypeNotAvailableException(String reason) {
        super(reason);
    }

    public TypeNotAvailableException(String reason, Throwable cause) {
        super(reason, cause);
    }

    /** Return a suitable TypeNotAvailableException if o cannot be converted to */
    public static TypeNotAvailableException checkCompatible(Object o, Class<?> c, String info) {
        if(o == null) {
            return null;
        }

        if(c.isAssignableFrom(o.getClass())) {
            return null;
        }

        return new TypeNotAvailableException(
                info
                + " is a " + o.getClass().getName()
                + ", not compatible with " + c.getClass().getName()
        );

    }
}
