/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons;

import org.apache.sling.runmode.RunMode;
import org.osgi.service.component.ComponentConstants;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;

/**
 * RunMode utilities.
 *
 * Instead of directly using the run mode service, it is better to make
 * the component in question require a configuration (see OSGI Declarative
 * Services Spec: configuration policy). In this case, a component gets
 * only active if a configuration is available. Such a configuration can
 * be put into the repository for the specific run mode.
 *
 * @deprecated
 */
@Deprecated
public class RunModeUtil {

	/** Name to use for the property that configures
	 * 	the run modes of a component
	 */
	public static final String RUN_MODES_PROPERTY = "run.modes";

    /** Use this to disable a component if none of its run modes are active
     * @param rm {@link RunMode}
     * @param componentRunModes component run modes
     * @param ctx component context
     * @param log logger
     * @return true if component was disabled
     */
    public static boolean disableIfNoRunModeActive(RunMode rm, String [] componentRunModes, ComponentContext ctx, Logger log) {
        final String name = (String)ctx.getProperties().get(ComponentConstants.COMPONENT_NAME);
        boolean result = false;

        if(!rm.isActive(componentRunModes)) {
            if(log.isInfoEnabled()) {
                log.info("Component " + name
                        + " disabled as its none of its run modes (" + dump(componentRunModes) + ")"
                        + " are currently active (" + rm + ")"
                );
            }
            ctx.disableComponent(name);
            result = true;

        } else if(log.isInfoEnabled()) {
            log.info("Component " + name
                    + " enabled as at least one of its run modes (" + dump(componentRunModes) + ")"
                    + " are currently active (" + rm + ")"
            );
        }

        return result;
    }

    /** Debugging dump */
    private static String dump(String [] a) {
        final StringBuffer sb = new StringBuffer();
        for(int i=0; i < a.length; i++) {
            if(i > 0) {
                sb.append(", ");
            }
            sb.append(a[i]);
        }
        return sb.toString();
    }
}
