/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.api.s7dam.set;

import com.day.cq.dam.api.s7dam.set.MediaSet;
import com.day.cq.dam.api.Asset;
import java.util.Map;

/**
 * Represents a Scene7 Carousel Set
 *
 */
public interface CarouselSet extends MediaSet {

    public final static String IMAGE_MAP_PROPERTY = "dam:s7imagemap";

    /**
     * Add a slide to carousel set
     * @param asset asset for slide
     * @param props properties for slide
     */
    public void addSlide(Asset asset, Map<String, Object> props);

    /**
     * List all set member
     * @return set members
     */
    public SetMember[] getAssets();

}
