/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.commons.handler;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import com.day.cq.dam.api.Context;
import com.day.cq.dam.api.ProcessorException;

/**
 * Simple context that remembers all metadata and thumbnail images found.
 *
 * @author dpfister
 */
public class SimpleContext implements Context {

    /**
     * List of metadata found.
     */
    private List<InputStream> metas;

    /**
     * List of thumbnails found.
     */
    private List<BufferedImage> thumbnails;

    /**
     * List of exceptions.
     */
    private List<ProcessorException> exceptions;

    /**
     * Return all metadata found, as an array.
     *
     * @return metadata or <code>null</code>
     */
    public InputStream[] getMetadata() {
        if (metas != null) {
            return metas.toArray(new InputStream[0]);
        }
        return  null;
    }

    /**
     * Return all images found, as an array.
     *
     * @return images or <code>null</code>
     */
    public BufferedImage[] getThumbnails() {
        if (thumbnails != null) {
            return thumbnails.toArray(new BufferedImage[0]);
        }
        return null;
    }

    /**
     * Return all exceptions found during processing.
     *
     * @return exceptions or <code>null</code>
     */
    public ProcessorException[] getExceptions() {
        if (exceptions != null) {
            return exceptions.toArray(new ProcessorException[0]);
        }
        return null;
    }

    //------------------------------------------------------------------ Context

    /**
     * {@inheritDoc}
     */
    public void addException(ProcessorException e) {
        if (exceptions == null) {
            exceptions = new ArrayList<ProcessorException>();
        }
        exceptions.add(e);
    }

    /**
     * {@inheritDoc}
     */
    public void addMetadata(InputStream meta) {
        if (metas == null) {
            metas = new ArrayList<InputStream>();
        }
        metas.add(meta);
    }

    /**
     * {@inheritDoc}
     */
    public void addThumbnail(BufferedImage image) {
        if (thumbnails == null) {
            thumbnails = new ArrayList<BufferedImage>();
        }
        thumbnails.add(image);
    }
}
