/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api.model;

import org.jetbrains.annotations.Nullable;

/**
 * A viewer configuration setting
 *
 * Return values and parameters are @NotNull by default.
 */
public class Scene7ConfigSetting {
    private final String name;
    private final String value;
    private final String handle;

    /**
     * Create a new viewer preset
     * @param name
     *          name of the preset
     * @param value
     *          (optional) value of the preset
     * @param handle
     *          (optional) handle to the stored config
     */
    public Scene7ConfigSetting(String name, @Nullable String value, @Nullable String handle) {
        this.name = name;
        this.value = value;
        this.handle = handle;
    }

    /**
     * Retrieve the name of the preset
     *
     * @return
     *          The preset name
     */
    public String getName() {
        return this.name;
    }

    /**
     * Retrieve the value of the preset
     *
      * @return
     *          The preset value
     */
    @Nullable
    public String getValue() {
        return this.value;
    }

    /**
     * Retrieve the handle to the stored configuration
     *
     * @return
     *          The optional handle value, might be {@code null}
     */
    @Nullable
    public String getHandle() {
        return this.handle;
    }
}
