/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.mcm.campaign;

/**
 * Thrown when a connection to Adobe Campaign fails or returns
 * with an unexpected status code.
 */
public class ConnectionException extends ACConnectorException {

    private int statusCode = -1;

    public ConnectionException(String message) {
        super(message);
    }

    public ConnectionException(String message, Throwable cause) {
        super(message, cause);
    }

    public ConnectionException(String message, int statusCode) {
        super(message);
        this.statusCode = statusCode;
    }

    public ConnectionException(String message, Throwable cause, int statusCode) {
        super(message, cause);
        this.statusCode = statusCode;
    }

    /**
     * Returns the response status code of the request to Adobe Campaign if this
     * exception was caused by receiving an unexpected status code. Otherwise it
     * returns -1;
     * @return The response status code or -1
     */
    public int getStatusCode() {
        return statusCode;
    }

}
