/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * Agent filter that filters for agent names.
 */
public class AgentIdFilter implements AgentFilter {

    /**
     * set of ids to include
     */
    private final Set<String> ids = new HashSet<String>();

    /**
     * Creates a new filter.
     * @param ids the ids to filter for.
     */
    public AgentIdFilter(String ... ids) {
        if (ids != null) {
            this.ids.addAll(Arrays.asList(ids));
        }
    }

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if the given agent id is included in this filter.
     */
    public boolean isIncluded(Agent agent) {
        return ids.contains(agent.getId());
    }
}