/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.parser.taghandlers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;

import org.apache.jackrabbit.commons.JcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.day.cq.commons.jcr.JcrUtil;

/**
 * Builds the canvas component script
 */
public class CanvasComponentBuilder {

    static private final String ROOT = "/apps";

    private Session session;

    private String resourceType;

    private StringBuffer scriptContentBuffer = new StringBuffer("<%@include file=\"/libs/foundation/global.jsp\"%>" + "\n" +
                      "<%@ page contentType=\"text/html; charset=utf-8\" %>" + "\n");

    private Logger log = LoggerFactory.getLogger(CanvasComponentBuilder.class);

    public void setSession(Session session) {
        this.session = session;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setScriptContent(String scriptContent) {
        scriptContentBuffer = new StringBuffer(scriptContent);
    }

    public void appendScriptContent(String scriptContent) {
        scriptContentBuffer.append(scriptContent);
    }

    public void prependScriptContent(String scriptContent) {
        scriptContentBuffer.insert(0, scriptContent);
    }

    public String getScriptContent() {
        return scriptContentBuffer.toString();
    }

    public void build() throws RepositoryException {
        Node canvasComponent = JcrUtil.createPath(ROOT + "/" + resourceType, NodeType.NT_FOLDER, "cq:Component", session, true);
        String scriptName = getComponentName() + ".jsp";
		InputStream jspStream;
		try {
		    jspStream = new ByteArrayInputStream(getScriptContent().getBytes("UTF-8"));
		} catch (UnsupportedEncodingException e) {
		    log.warn("Could not encode content using UTF-8, so using platform's default charset instead", e);
		    jspStream = new ByteArrayInputStream(getScriptContent().getBytes());
		}
		JcrUtils.putFile(canvasComponent, scriptName, "text/plain", jspStream);
    }

    private String getComponentName() {
        int i = resourceType.lastIndexOf('/');
        String componentName = resourceType.substring(i + 1, resourceType.length());
        return componentName;
    }

}
