/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.parser.taghandlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import com.day.cq.wcm.designimporter.ErrorCodes;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.xml.sax.Attributes;

import com.day.cq.dam.indd.PageComponent;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.UnsupportedTagContentException;
import com.day.cq.wcm.designimporter.api.ContainerComponentProvider;
import com.day.cq.wcm.designimporter.api.EntryTagHandler;

/**
 * The canvas component tag handler is the top level or the "root" tag handler which handles the entry tag &lt;div id="cqcanvas"&gt; The body markup outside the bounds of the #cqcanvas tag is ignored.
 *
 * <p>
 * This tag handler is registered against the markup of type &lt;div id="cqcanvas"&gt;. That implies
 * this tag handler will come into action whenever the design importer framework
 * encounters an HTML tag matching the rule this handler is defined against.
 * </p>
 *
 * @see com.day.cq.wcm.designimporter.parser.taghandlers.factory.TextComponentTagHandlerFactory
 */
public class CanvasComponentTagHandler extends AbstractTagHandler implements EntryTagHandler, ContainerComponentProvider {

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        super.startElement(uri, localName, qName, atts);

        if (delegate instanceof CanvasComponentTagHandler) {
            throw new UnsupportedTagContentException(ErrorCodes.NESTED_CANVAS_COMPONENT); //"Nested canvas div encountered"
        }
    }

    @Override
    public void endHandling(String uri, String localName, String qName) throws DesignImportException {
        super.endHandling(uri, localName, qName);
        Map<String, Object> base = new HashMap<String, Object>();
        // base.put("text", htmlBuffer.toString());
        ValueMap properties = new ValueMapDecorator(base);

        PageComponent canvasComponent = pageBuilder.createComponent(getResourceType(), properties, getNameHint());
        canvasComponent.getChildComponents().addAll(getPageComponents());
        pageComponents = new ArrayList<PageComponent>();
        pageComponents.add(canvasComponent);
    }

    private String getNameHint() {
        return "canvas";
    }

    private String resourceType = "geometrixx/components/canvaspage/canvas1234";

    public String getResourceType() {
        return resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

}
