/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.foundation.model.responsivegrid.export;

import com.adobe.cq.export.json.ContainerExporter;
import com.day.cq.wcm.foundation.model.export.AllowedComponentsExporter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Map;

/**
 * Describes the export behavior of a ResponsiveGrid.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@ProviderType
public interface ResponsiveGridExporter extends ContainerExporter {

    /**
     * @return The CSS class names to be applied to the current grid.
     */
    @Nullable
    String getGridClassNames();

    /**
     * @return The CSS class names associated with each responsive grid column and listed by column name
     */
    @Nonnull
    Map<String, String> getColumnClassNames();

    /**
     * @return The number of columns available for direct children in the grid.
     */
    int getColumnCount();

    /**
     * @return Allowed Components object for the current grid.
     */
    @JsonProperty("allowedComponents")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    AllowedComponentsExporter getExportedAllowedComponents();

    /**
     * Returns the style system information associated with the current grid.
     *
     * @return CSS classes selected by the content author delimited using a SPACE character
     *
     * @since com.adobe.cq.wcm.core.components.models 12.20.0
     */
    @Nullable
    @JsonProperty("appliedCssClassNames")
    String getAppliedCssClasses();
}
