/*
 *
 *  ADOBE CONFIDENTIAL
 *  __________________
 *
 *   Copyright 2015 Adobe Systems Incorporated
 *   All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains
 *  the property of Adobe Systems Incorporated and its suppliers,
 *  if any.  The intellectual and technical concepts contained
 *  herein are proprietary to Adobe Systems Incorporated and its
 *  suppliers and may be covered by U.S. and Foreign Patents,
 *  patents in process, and are protected by trade secret or copyright law.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe Systems Incorporated.
 *
 */

package com.day.cq.wcm.msm.api;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import com.day.cq.wcm.api.WCMException;

/**
 * This is a Service-Provider Interface.
 * It is intended to implement how conflicts in the Resource names between a Blueprint Resource and a LiveCopy
 * Resource are handled during a {@link RolloutManager#rollout(RolloutManager.RolloutParams) roll-out}.
 * Following is considered a conflict: A Resource exists for a  {@link Resource#getName() name}
 * in Blueprint and in the LiveCopy. But the LiveCopy's Resource has not been created by a roll-out.
 *
 * @see RolloutManager
 */
public interface ResourceNameRolloutConflictHandler {

    /**
     * This method will be called in case a Resource to roll-out exists at same name in LiveCopy but is manually created.
     * Which would block a {@link Resource} to inherit from its {@link Blueprint}.
     * <p/>
     * The implementation can request to roll-out the Blueprint Resource of the conflict after its call by returning
     * <i>true</i><br>
     * Returning <i>false</i> will not be considered a failure in conflict resolution.
     * These must be indicated by exception.
     *
     * @param conflictRelation the LiveRelationship that resulted in a name Conflict.
     * @param resourceResolver the ResourceResolver used for the conflicting roll-out
     * @param isReset          if the roll-out was a reset
     * @return true in case the handler desires the roll-out to happen after its actions / false if nothing should happen.
     * @throws WCMException in case of failure to act.
     * @see com.day.cq.wcm.msm.api.LiveStatus#getAdvancedStatus(String)
     * @see com.day.cq.wcm.msm.api.MSMNameConstants#PARAM_IS_TARGET_MANUALLY_CREATED
     */
    boolean handleNameConflict(LiveRelationship conflictRelation, ResourceResolver resourceResolver, boolean isReset)
            throws WCMException;
}
