package com.day.cq.workflow;

import com.day.cq.workflow.exec.Workflow;

import java.util.List;

/**
 * The <code>PayloadMap</code> is listening to workflow events (started,
 * terminated, completed and manages a payload map (only JCR_PATH payloads)
 * in order to enable quick lookup for nodes/resources which might be subject
 * of a workflow.
 */
public interface PayloadMap {
    /**
     * Checks whether a <code>JCR_PATH</code>based path is subject of a running <code>
     * {@link com.day.cq.workflow.exec.Workflow} instance</code>.
     * <b>Note:</b>The system workflows (can be defined per osgi config) won't
     * be taken in account here!
     *
     * @param path path to check
     * @return <code>true</code> if <code>JCR_PATH</code>based path is subject of a
     * running workflow
     *
     * @deprecated use {@link PayloadMap#isInWorkflow(String, boolean)} instead!
     */
    boolean isInWorkflow(String path);

    /**
     * Checks whether a <code>JCR_PATH</code>based path is subject of a running <code>
     * {@link com.day.cq.workflow.exec.Workflow} instance</code>.
     *
     * @param path path to check
     * @param excludeSystemWorkflows set to <code>true</code> to exclude system
     *        workflows from the evaluation
     *
     * @return <code>true</code> if <code>JCR_PATH</code>based path is subject of a
     * running workflow
     */
    boolean isInWorkflow(String path, boolean excludeSystemWorkflows);

    /**
     * The <code>{@link com.day.cq.workflow.exec.Workflow} instance</code> is
     * returned.
     * <b>Note:</b>The system workflows (can be defined per osgi config) won't
     * be taken in account here!
     *
     * @param path node path
     * @return the <code>{@link com.day.cq.workflow.exec.Workflow} instance </code>
     * or <code>null</code> if not existing.
     *
     * @deprecated use {@link PayloadMap#getWorkflowInstances(String, boolean)}  instead!
     */
    Workflow getWorkflowInstance(String path);

    /**
     * All <code>{@link com.day.cq.workflow.exec.Workflow} instances</code> are
     * returned.
     *
     * @param path node path
     * @param excludeSystemWorkflows set to <code>true</code> to exclude system
     *        workflows from the evaluation
     *
     * @return the list of <code>{@link com.day.cq.workflow.exec.Workflow} instances</code>
     * or an empty list is returned
     */
    public List<Workflow> getWorkflowInstances(String path, boolean excludeSystemWorkflows);
}
