/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow;

import java.util.Dictionary;

import javax.jcr.Session;

import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.model.WorkflowModel;

/**
 * The <code>WorkflowService</code> is the main entry point for accessing the
 * workflow engine. It defines life cycle methods for the workflow engine (eg to
 * {@link #start()}/{@link #stop()} it).
 * 
 * <p>
 * It also provides functionality for getting a
 * <code>{@link WorkflowSession}</code> per user based on the users JCR
 * session and according credentials.
 * 
 * Instances of the <code>{@link WorkflowSession}</code> interface are used
 * for all workflow operations like deploying a new {@link WorkflowModel} or
 * starting a new {@link Workflow} instance.
 * 
 */
public interface WorkflowService {
	/**
	 * The start method will initialize and start the
	 * <code>WorkflowService</code> properly.
	 * 
	 * @throws WorkflowException
	 *             Thrown in case that the initialization procedure fails.
	 */
	void start() throws WorkflowException;

	/**
	 * This methods will shutdown the <code>WorkflowService</code> properly.
	 * All active workflows will be suspended and all running processes will be
	 * terminated.
	 */
	void stop();

	/**
	 * Creates a new <code>{@link WorkflowSession}</code> based on the given
	 * JCR session. The credentials of the JCR session define what the user can
	 * access and which operations he is allowed to do.
	 * 
	 * @param session
	 *            The users JCR session to be used for initializing the
	 *            <code>{@link WorkflowSession}</code>.
	 * @return A new instance of the <code>{@link WorkflowSession}</code>
	 *         based on the given JCR session.
	 */
	WorkflowSession getWorkflowSession(Session session);

	/**
	 * Allows users of the <code>WorkflowService</code> to retrieve settings
	 * and parameters related to the <code>WorkflowService</code>
	 * implementation. In common these are provided by the environment (eg. a
	 * OSGi compliant container or a servlet engine.
	 * 
	 * @return Returns the map of configuration parameters for the
	 *         <code>WorkflowService</code>.
	 */
	Dictionary<String, Object> getConfig();
}
