/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2012 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.cq.history.filter;

import java.util.Collection;
import java.util.HashSet;

import com.adobe.cq.history.api.HistoryEntry;
import com.day.cq.commons.Filter;

public class ResourceTypesFilter implements Filter<HistoryEntry> {

    private Collection<String> filteredResourceTypes = new HashSet<String>();

    public ResourceTypesFilter(Collection<String> filteredResourceTypes) {
        this.filteredResourceTypes.addAll(filteredResourceTypes);
    }

    @Override
    public boolean includes(HistoryEntry historyEntry) {
        for (String resourceType : historyEntry.getResourceTypes()) {
            if (filteredResourceTypes.contains(resourceType)) {
                return true;
            }
        }

        return filteredResourceTypes.isEmpty();
    }

}
