/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.granite.socketio;

import java.util.Map;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Socket.IO namespace. Each namespace can have a number of connected sockets.
 */
@ProviderType
public interface SocketIONamespace extends SocketIOEmitter {

    /**
     * Name of the default namespace.
     */
    public static final String DEFAULT_NAME = "/";

    /**
     * Returns the name of this namespace.
     * @return the name
     */
    @Nonnull
    String getName();

    /**
     * Returns a map of all connected sockets. The key of the map corresponds to the socket ids.
     * @return the map of connected sockets.
     */
    @Nonnull
    Map<String, SocketIOSocket> getConnected();

    /**
     * Returns the socket with the given id or {@code null} if it does not exist.
     * @param id the socket id.
     * @return a socket or {@code null}.
     */
    @CheckForNull
    SocketIOSocket getSocket(@Nonnull String id);

}