/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2001-2002, Adobe Systems Incorporated                        */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/
package com.adobe.versioncue.nativecomm.msg;




/**
  * @author  <a href="mailto:tnaroska@adobe.com">Timo Naroska</a>
  * @version $Revision: #1 $
  */
public abstract class NCType implements INCExternalizable
{
	// ---------------------------------------------------------------------------- Public Constants

	/** Type ID void */
	public static final int TYPE_NULL = 0;

	/** Type ID int */
	public static final int TYPE_INTEGER = 1;

	/** Type ID boolean */
	public static final int TYPE_BOOLEAN = 2;

	/** Type ID float */
	public static final int TYPE_DOUBLE = 3;

	/** Type ID string */
	public static final int TYPE_STRING = 4;

	/** Type ID byte[] */
	public static final int TYPE_BYTEBUFFER = 5;

	/** Type ID NCList */
	public static final int TYPE_LIST = 6;

	/** Type ID Dictionary */
	public static final int TYPE_MAP = 7;

	/** Type ID long (64 bit) */
	public static final int TYPE_LONG = 8;

	/** Type ID date 64 bit milliseconds GMT */
	public static final int TYPE_DATE = 9;

	// ----------------------------------------------------------------- Package Visible Constructor

	/** Ctor to prevent subclassing from outside this package */
	NCType()
	{
		// Empty
	}
	
	// --------------------------------------------------------------------- Public Abstract Methods

	/** Returns the type of this <code>NCType</code> object.
	 * @return the type of this <code>NCType</code>
	 */
	public abstract int getType();

	/** Force subclasses to implement.
	 *  @see Object#hashCode()
	 */
	public abstract int hashCode();

	/** Force subclasses to implement.
	 * @see Object#equals(java.lang.Object)
	 */
	public abstract boolean equals(Object other);

	/** Force subclasses to implement.
	 * @see java.lang.Object#toString()
	 */
	public abstract String toString();

	// ------------------------------------------------------------------------------ Public Methods

	/** @see INCExternalizable#externalize() */
	public NCType externalize()
	{
		return this;
	}
}
