/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security;

import javax.jcr.Session;

/**
 * Small Interface to register and retrieve a Service resolving the
 * {@link User User} associated to a Session.
 * These is needed as {@link javax.jcr.Session Sessions} do not require a User
 * associated to it nor does the it's User-Id require to provide a
 * unique / useful identifier.
 * If there is a User with a Session depends on the Repository's Configuration.
 * Thus there may be cases, where no User can be resolved for a valid Session.
 *
 * @see javax.jcr.Session#getUserID()
 * @deprecated cq 5.5
 */
public interface UserResolver {

    /**
     * Resolve the User based on a Session.
     * The Session's {@link javax.jcr.Session#getUserID() user-Id} is required
     * to be the same as the string entered with the login.
     * The relation of this ID to a User depends on the Login-Module.
     * As this is out of the scope of CQ, there are cases where the
     * Session's user-id is not the same as the User's {@link com.day.cq.security.User#getID() id}.
     * <br>
     *
     * @param session to search user for it
     * @return User or <code>null</code> if based on the Sessions User-ID can't be found
     */
    User resolveUser(Session session);
}