/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.wcm.api;

import java.util.Calendar;

import javax.jcr.version.Version;

import org.apache.sling.api.resource.ValueMap;

/**
 * Defines the interface of a CQ page revision.
 */
public interface Revision {

    /**
     * Returns the underlying version.
     * @return the JCR version
     * @since 5.5
     */
    Version getVersion();

    /**
     * Returns a property map of the page content. If the page has no content
     * an empty property map is returned.
     *
     * @return a value map
     * @see #hasContent()
     */
    ValueMap getProperties();

    /**
     * Returns a property map of the address content of the page. Respective
     * content does not exit, <code>null</code> is returned.
     *
     * @param relPath relative path to the content
     * @return a value map or <code>null</code>
     *
     * @throws IllegalArgumentException of the given path is not relative.
     */
    ValueMap getProperties(String relPath);

    /**
     * Return the version label.
     * @return version label
     */
    String getLabel();

    /**
     * Return the unique version id.
     * @return version id
     */
    String getId();

    /**
     * Return a flag indicating whether this revision belongs to a deleted
     * page.
     * @return <code>true</code> if the associated page is deleted;
     *         <code>false</code> otherwise
     */
    boolean isDeleted();

    /**
     * Indicates if this revision is the current base version of the respective page.
     * @return <code>true</code> if base version.
     * @since 5.5
     */
    boolean isBaseVersion();

    /**
     * Returns the name of the page. this is the last path segment of the
     * page path.
     * @return page name
     */
    String getName();

    /**
     * Return the parent path of the page.
     *
     * @return parent path
     */
    String getParentPath();

    /**
     * Returns the title of the page or <code>null</code> if none defined.
     * The title is a short form of the page title, usually displayed in the
     * site admin.
     * @return title of the page
     */
    String getTitle();

    /**
     * Returns the description of this resource.
     * @return the description of this resource or <code>null</code> if not defined.
     */
    String getDescription();

    /**
     * Returns the page title of the page or <code>null</code> if none defined.
     * @return page title
     */
    String getPageTitle();

    /**
     * Returns the navigation title of the page or <code>null</code> if none
     * defined. The navigation title is usually used when drawing navigation
     * links.
     * @return navigation title
     */
    String getNavigationTitle();

    /**
     * Returns the "hideInNav" flag or <code>false</code> if non defined.
     * The hideInNav flag is usually used to control if a page should be
     * displayed in a navigation.
     * @return hide in navigation flag
     */
    boolean isHideInNav();

    /**
     * Checks if the page has content attached.
     * @return <code>true</code> if the page has content;
     *         <code>false</code> otherwise.
     */
    boolean hasContent();

    /**
     * Returns the vanity url.
     * @return The vanity url for this page or <code>null</code>
     */
    String getVanityUrl();

    /**
     * Return the creation date.
     *
     * @return creation date
     */
    Calendar getCreated();

    /**
     * Return the optional comment for this revision.
     *
     * @return comment or <code>null</code>
     */
    String getComment();

    /**
     * Returns the path of the existing page if exists.
     * @return the path of the existing page.
     */
    String getExistingPagePath();
}
