/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.api;

import java.util.Map;

import org.xml.sax.Attributes;

/**
 * Registers and creates {@link TagHandler}s
 *
 * <p>
 * {@link TagHandler}s are registered against a tag and its corresponding attributes. The tag handlers
 * registered against the same tag name are prioritized according to their attributes.
 * </p>
 */
public interface TagHandlerProvider {

    /**
     * Creates a {@link TagHandler} for the passed tag and {@link Attributes}
     * 
     * @param tag
     * @param atts
     * @return
     */
    TagHandler createTagHandler(String tag, Attributes atts);

}
