/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.foundation.model.responsivegrid;

import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;

/**
 * Configuration containing the list of all the {@link Breakpoint}s of a given resource.
 */
@ProviderType
public class ResponsiveConfiguration {

    private Map<String, Breakpoint> breakpoints = new HashMap<String, Breakpoint>();

    public ResponsiveConfiguration() {}

    public ResponsiveConfiguration(Map<String, Breakpoint> breakpoints) {
        this.breakpoints = breakpoints;
    }

    /**
     * Add a breakpoint to the list of breakpoints for the responsive configuration.
     *
     * @param breakpoint The breakpoint to be added to the responsive configuration.
     */
    public void addBreakpoint(Breakpoint breakpoint) {
        breakpoints.put(breakpoint.getName(), breakpoint);
    }

    /**
     *
     * @return A map containing all the breakpoints (breakpoint name used as the key) for the responsive configuration.
     */
    @Nonnull
    public Map<String, Breakpoint> getBreakpoints() {
        return breakpoints;
    }

}

