/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.commons.log.logback.webconsole;

import java.util.Arrays;

// @deprecated This internal logback API is not supported by AEM as a Cloud Service.
@Deprecated(since = "2022-01-27")
public final class LoggerConfig {

    private final String pid;

    private final String logLevel;

    private final String[] loggers;

    private final String logFile;

    private boolean additive;

    public LoggerConfig(String pid, String logLevel, String[] loggers, String logFile, boolean additive) {
        this.pid = pid;
        this.logLevel = logLevel;
        this.loggers = Arrays.copyOf(loggers, loggers.length);
        this.logFile = logFile;
        this.additive = additive;
    }

    public String getPid() {
        return pid;
    }

    public String getLogLevel() {
        return logLevel;
    }

    public String[] getLoggers() {
        return loggers;
    }

    public String getLogFile() {
        return logFile;
    }

    public boolean isAdditive() {
        return additive;
    }
}
