// This file is part of TagSoup and is Copyright 2002-2008 by John Cowan.
//
// TagSoup is licensed under the Apache License,
// Version 2.0.  You may obtain a copy of this license at
// http://www.apache.org/licenses/LICENSE-2.0 .  You may also have
// additional legal rights not granted by this license.
//
// TagSoup is distributed in the hope that it will be useful, but
// unless required by applicable law or agreed to in writing, TagSoup
// is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
// OF ANY KIND, either express or implied; not even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// 
// 
/**
This class provides a Schema that has been preinitialized with HTML
elements, attributes, and character entity declarations.  All the declarations
normally provided with HTML 4.01 are given, plus some that are IE-specific
and NS4-specific.  Attribute declarations of type CDATA with no default
value are not included.
*/

package org.ccil.cowan.tagsoup;
public class HTMLSchema extends Schema implements HTMLModels {

	/**
	Returns a newly constructed HTMLSchema object independent of
	any existing ones.
	*/

	public HTMLSchema() {
		// Start of Schema calls
				setURI("http://www.w3.org/1999/xhtml");
		setPrefix("html");
		elementType("<pcdata>", M_EMPTY, M_PCDATA, 0);
		elementType("<root>", M_ROOT, M_EMPTY, 0);
		elementType("a", M_PCDATA|M_NOLINK, M_INLINE, 0);
		elementType("abbr", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("acronym", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("address", M_PCDATA|M_INLINE|M_P, M_BLOCK, 0);
		elementType("applet", M_PCDATA|M_PARAM|M_INLINE|M_BLOCK, M_INLINE|M_NOLINK, 0);
		elementType("area", M_EMPTY, M_AREA, 0);
		elementType("b", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("base", M_EMPTY, M_HEAD, 0);
		elementType("basefont", M_EMPTY, M_INLINE|M_NOLINK, 0);
		elementType("bdo", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("bgsound", M_EMPTY, M_HEAD, 0);
		elementType("big", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("blink", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("blockquote", M_PCDATA|M_INLINE|M_BLOCK, M_BLOCK, 0);
		elementType("body", M_PCDATA|M_INLINE|M_BLOCK, M_HTML|M_BODY, 0);
		elementType("br", M_EMPTY, M_INLINE|M_NOLINK, 0);
		elementType("button", M_PCDATA|M_INLINE|M_BLOCK, M_INLINE|M_NOLINK, 0);
		elementType("canvas", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		elementType("caption", M_PCDATA|M_INLINE, M_TABULAR, 0);
		elementType("center", M_PCDATA|M_INLINE|M_BLOCK, M_BLOCK, 0);
		elementType("cite", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("code", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("col", M_EMPTY, M_COL|M_TABULAR, 0);
		elementType("colgroup", M_COL, M_TABULAR, 0);
		elementType("comment", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		elementType("dd", M_PCDATA|M_INLINE|M_BLOCK, M_DEF, 0);
		elementType("del", M_PCDATA|M_INLINE|M_BLOCK, M_INLINE|M_BLOCKINLINE|M_BLOCK, F_RESTART);
		elementType("dfn", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("dir", M_LI, M_BLOCK, 0);
		elementType("div", M_PCDATA|M_INLINE|M_BLOCK, M_BLOCK, 0);
		elementType("dl", M_DEF, M_BLOCK, 0);
		elementType("dt", M_PCDATA|M_INLINE, M_DEF, 0);
		elementType("em", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("fieldset", M_PCDATA|M_LEGEND|M_INLINE|M_BLOCK, M_BLOCK, 0);
		elementType("font", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		elementType("form", M_PCDATA|M_INLINE|M_NOLINK|M_BLOCK|M_TR|M_CELL, M_BLOCK|M_FORM, F_NOFORCE);
		elementType("frame", M_EMPTY, M_FRAME, 0);
		elementType("frameset", M_FRAME, M_FRAME|M_HTML, 0);
		elementType("h1", M_PCDATA|M_INLINE, M_BLOCK, 0);
		elementType("h2", M_PCDATA|M_INLINE, M_BLOCK, 0);
		elementType("h3", M_PCDATA|M_INLINE, M_BLOCK, 0);
		elementType("h4", M_PCDATA|M_INLINE, M_BLOCK, 0);
		elementType("h5", M_PCDATA|M_INLINE, M_BLOCK, 0);
		elementType("h6", M_PCDATA|M_INLINE, M_BLOCK, 0);
		elementType("head", M_HEAD, M_HTML, 0);
		elementType("hr", M_EMPTY, M_BLOCK, 0);
		elementType("html", M_HTML, M_ROOT, 0);
		elementType("i", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("iframe", M_PCDATA|M_INLINE|M_BLOCK, M_INLINE|M_NOLINK, 0);
		elementType("img", M_EMPTY, M_INLINE|M_NOLINK, 0);
		elementType("input", M_EMPTY, M_INLINE|M_NOLINK, 0);
		elementType("ins", M_PCDATA|M_INLINE|M_BLOCK, M_INLINE|M_BLOCK, F_RESTART);
		elementType("isindex", M_EMPTY, M_HEAD, 0);
		elementType("kbd", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("label", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		elementType("legend", M_PCDATA|M_INLINE, M_LEGEND, 0);
		elementType("li", M_PCDATA|M_INLINE|M_BLOCK, M_LI, 0);
		elementType("link", M_EMPTY, M_HEAD|M_INLINE, 0);
		elementType("listing", M_PCDATA|M_INLINE, M_BLOCK, 0);
		elementType("map", M_BLOCK|M_AREA, M_INLINE, 0);
		elementType("marquee", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		elementType("menu", M_LI, M_BLOCK, 0);
		elementType("meta", M_EMPTY, M_HEAD, 0);
		elementType("nobr", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		elementType("noframes", M_BODY|M_BLOCK|M_INLINE, M_BLOCK|M_HTML|M_FRAME, 0);
		elementType("noscript", M_PCDATA|M_INLINE|M_BLOCK, M_ANY & ~M_ROOT, 0);
		elementType("object", M_PCDATA|M_PARAM|M_INLINE|M_BLOCK, M_HEAD|M_INLINE|M_NOLINK, 0);
		elementType("ol", M_LI, M_BLOCK, 0);
		elementType("optgroup", M_OPTIONS, M_OPTIONS, 0);
		elementType("option", M_PCDATA, M_OPTION|M_OPTIONS, 0);
		elementType("p", M_PCDATA|M_INLINE|M_TABLE, M_BLOCK|M_P, 0);
		elementType("param", M_EMPTY, M_PARAM, 0);
		elementType("pre", M_PCDATA|M_INLINE, M_BLOCK, 0);
		elementType("q", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("rb", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("rbc", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("rp", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("rt", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("rtc", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("ruby", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("s", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("samp", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("script", M_PCDATA, M_ANY & ~M_ROOT, F_CDATA);
		elementType("select", M_OPTIONS, M_INLINE, 0);
		elementType("small", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("span", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		elementType("strike", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("strong", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("style", M_PCDATA, M_HEAD|M_INLINE, F_CDATA);
		elementType("sub", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("sup", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("table", M_FORM|M_TABULAR, M_BLOCK|M_TABLE, F_NOFORCE);
		elementType("tbody", M_TR, M_TABULAR, 0);
		elementType("td", M_PCDATA|M_INLINE|M_BLOCK, M_CELL, 0);
		elementType("textarea", M_PCDATA, M_INLINE, 0);
		elementType("tfoot", M_TR|M_FORM|M_CELL, M_TABULAR, 0);
		elementType("th", M_PCDATA|M_INLINE|M_BLOCK, M_CELL, 0);
		elementType("thead", M_TR|M_FORM|M_CELL, M_TABULAR, 0);
		elementType("title", M_PCDATA, M_HEAD, 0);
		elementType("tr", M_FORM|M_CELL, M_TR|M_TABULAR, 0);
		elementType("tt", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("u", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		elementType("ul", M_LI, M_BLOCK, 0);
		elementType("var", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		elementType("wbr", M_EMPTY, M_INLINE|M_NOLINK, 0);
		elementType("xmp", M_PCDATA|M_INLINE, M_BLOCK, 0);
		parent("<pcdata>", "body");
		parent("html", "<root>");
		parent("a", "body");
		parent("abbr", "body");
		parent("acronym", "body");
		parent("address", "body");
		parent("applet", "body");
		parent("area", "map");
		parent("b", "body");
		parent("base", "head");
		parent("basefont", "body");
		parent("bdo", "body");
		parent("bgsound", "head");
		parent("big", "body");
		parent("blink", "body");
		parent("blockquote", "body");
		parent("body", "html");
		parent("br", "body");
		parent("button", "form");
		parent("canvas", "body");
		parent("caption", "table");
		parent("center", "body");
		parent("cite", "body");
		parent("code", "body");
		parent("col", "table");
		parent("colgroup", "table");
		parent("comment", "body");
		parent("dd", "dl");
		parent("del", "body");
		parent("dfn", "body");
		parent("dir", "body");
		parent("div", "body");
		parent("dl", "body");
		parent("dt", "dl");
		parent("em", "body");
		parent("fieldset", "form");
		parent("font", "body");
		parent("form", "body");
		parent("frame", "frameset");
		parent("frameset", "html");
		parent("h1", "body");
		parent("h2", "body");
		parent("h3", "body");
		parent("h4", "body");
		parent("h5", "body");
		parent("h6", "body");
		parent("head", "html");
		parent("hr", "body");
		parent("i", "body");
		parent("iframe", "body");
		parent("img", "body");
		parent("input", "form");
		parent("ins", "body");
		parent("isindex", "head");
		parent("kbd", "body");
		parent("label", "form");
		parent("legend", "fieldset");
		parent("li", "ul");
		parent("link", "head");
		parent("listing", "body");
		parent("map", "body");
		parent("marquee", "body");
		parent("menu", "body");
		parent("meta", "head");
		parent("nobr", "body");
		parent("noframes", "html");
		parent("noscript", "body");
		parent("object", "body");
		parent("ol", "body");
		parent("optgroup", "select");
		parent("option", "select");
		parent("p", "body");
		parent("param", "object");
		parent("pre", "body");
		parent("q", "body");
		parent("rb", "body");
		parent("rbc", "body");
		parent("rp", "body");
		parent("rt", "body");
		parent("rtc", "body");
		parent("ruby", "body");
		parent("s", "body");
		parent("samp", "body");
		parent("script", "html");
		parent("select", "form");
		parent("small", "body");
		parent("span", "body");
		parent("strike", "body");
		parent("strong", "body");
		parent("style", "head");
		parent("sub", "body");
		parent("sup", "body");
		parent("table", "body");
		parent("tbody", "table");
		parent("td", "tr");
		parent("textarea", "form");
		parent("tfoot", "table");
		parent("th", "tr");
		parent("thead", "table");
		parent("title", "head");
		parent("tr", "tbody");
		parent("tt", "body");
		parent("u", "body");
		parent("ul", "body");
		parent("var", "body");
		parent("wbr", "body");
		parent("xmp", "body");
		attribute("a", "hreflang", "NMTOKEN", null);
		attribute("a", "shape", "CDATA", "rect");
		attribute("a", "tabindex", "NMTOKEN", null);
		attribute("applet", "align", "NMTOKEN", null);
		attribute("area", "nohref", "BOOLEAN", null);
		attribute("area", "shape", "CDATA", "rect");
		attribute("area", "tabindex", "NMTOKEN", null);
		attribute("br", "clear", "CDATA", "none");
		attribute("button", "disabled", "BOOLEAN", null);
		attribute("button", "tabindex", "NMTOKEN", null);
		attribute("button", "type", "CDATA", "submit");
		attribute("caption", "align", "NMTOKEN", null);
		attribute("col", "align", "NMTOKEN", null);
		attribute("col", "span", "CDATA", "1");
		attribute("col", "valign", "NMTOKEN", null);
		attribute("colgroup", "align", "NMTOKEN", null);
		attribute("colgroup", "span", "CDATA", "1");
		attribute("colgroup", "valign", "NMTOKEN", null);
		attribute("dir", "compact", "BOOLEAN", null);
		attribute("div", "align", "NMTOKEN", null);
		attribute("dl", "compact", "BOOLEAN", null);
		attribute("form", "enctype", "CDATA", "application/x-www-form-urlencoded");
		attribute("form", "method", "CDATA", "get");
		attribute("frame", "frameborder", "CDATA", "1");
		attribute("frame", "noresize", "BOOLEAN", null);
		attribute("frame", "scrolling", "CDATA", "auto");
		attribute("h1", "align", "NMTOKEN", null);
		attribute("h2", "align", "NMTOKEN", null);
		attribute("h3", "align", "NMTOKEN", null);
		attribute("h4", "align", "NMTOKEN", null);
		attribute("h5", "align", "NMTOKEN", null);
		attribute("h6", "align", "NMTOKEN", null);
		attribute("hr", "align", "NMTOKEN", null);
		attribute("hr", "noshade", "BOOLEAN", null);
		attribute("iframe", "align", "NMTOKEN", null);
		attribute("iframe", "frameborder", "CDATA", "1");
		attribute("iframe", "scrolling", "CDATA", "auto");
		attribute("img", "align", "NMTOKEN", null);
		attribute("img", "ismap", "BOOLEAN", null);
		attribute("input", "align", "NMTOKEN", null);
		attribute("input", "checked", "BOOLEAN", null);
		attribute("input", "disabled", "BOOLEAN", null);
		attribute("input", "ismap", "BOOLEAN", null);
		attribute("input", "maxlength", "NMTOKEN", null);
		attribute("input", "readonly", "BOOLEAN", null);
		attribute("input", "tabindex", "NMTOKEN", null);
		attribute("input", "type", "CDATA", "text");
		attribute("label", "for", "IDREF", null);
		attribute("legend", "align", "NMTOKEN", null);
		attribute("li", "value", "NMTOKEN", null);
		attribute("link", "hreflang", "NMTOKEN", null);
		attribute("marquee", "width", "NMTOKEN", null);
		attribute("menu", "compact", "BOOLEAN", null);
		attribute("meta", "http-equiv", "NMTOKEN", null);
		attribute("meta", "name", "NMTOKEN", null);
		attribute("object", "align", "NMTOKEN", null);
		attribute("object", "declare", "BOOLEAN", null);
		attribute("object", "tabindex", "NMTOKEN", null);
		attribute("ol", "compact", "BOOLEAN", null);
		attribute("ol", "start", "NMTOKEN", null);
		attribute("optgroup", "disabled", "BOOLEAN", null);
		attribute("option", "disabled", "BOOLEAN", null);
		attribute("option", "selected", "BOOLEAN", null);
		attribute("p", "align", "NMTOKEN", null);
		attribute("param", "valuetype", "CDATA", "data");
		attribute("pre", "width", "NMTOKEN", null);
		attribute("rt", "rbspan", "CDATA", "1");
		attribute("script", "defer", "BOOLEAN", null);
		attribute("select", "disabled", "BOOLEAN", null);
		attribute("select", "multiple", "BOOLEAN", null);
		attribute("select", "size", "NMTOKEN", null);
		attribute("select", "tabindex", "NMTOKEN", null);
		attribute("table", "align", "NMTOKEN", null);
		attribute("table", "frame", "NMTOKEN", null);
		attribute("table", "rules", "NMTOKEN", null);
		attribute("tbody", "align", "NMTOKEN", null);
		attribute("tbody", "valign", "NMTOKEN", null);
		attribute("td", "align", "NMTOKEN", null);
		attribute("td", "colspan", "CDATA", "1");
		attribute("td", "headers", "IDREFS", null);
		attribute("td", "nowrap", "BOOLEAN", null);
		attribute("td", "rowspan", "CDATA", "1");
		attribute("td", "scope", "NMTOKEN", null);
		attribute("td", "valign", "NMTOKEN", null);
		attribute("textarea", "cols", "NMTOKEN", null);
		attribute("textarea", "disabled", "BOOLEAN", null);
		attribute("textarea", "readonly", "BOOLEAN", null);
		attribute("textarea", "rows", "NMTOKEN", null);
		attribute("textarea", "tabindex", "NMTOKEN", null);
		attribute("tfoot", "align", "NMTOKEN", null);
		attribute("tfoot", "valign", "NMTOKEN", null);
		attribute("th", "align", "NMTOKEN", null);
		attribute("th", "colspan", "CDATA", "1");
		attribute("th", "headers", "IDREFS", null);
		attribute("th", "nowrap", "BOOLEAN", null);
		attribute("th", "rowspan", "CDATA", "1");
		attribute("th", "scope", "NMTOKEN", null);
		attribute("th", "valign", "NMTOKEN", null);
		attribute("thead", "align", "NMTOKEN", null);
		attribute("thead", "valign", "NMTOKEN", null);
		attribute("tr", "align", "NMTOKEN", null);
		attribute("tr", "valign", "NMTOKEN", null);
		attribute("ul", "compact", "BOOLEAN", null);
		attribute("ul", "type", "NMTOKEN", null);
		attribute("xmp", "width", "NMTOKEN", null);
		attribute("a", "class", "NMTOKEN", null);
		attribute("abbr", "class", "NMTOKEN", null);
		attribute("acronym", "class", "NMTOKEN", null);
		attribute("address", "class", "NMTOKEN", null);
		attribute("applet", "class", "NMTOKEN", null);
		attribute("area", "class", "NMTOKEN", null);
		attribute("b", "class", "NMTOKEN", null);
		attribute("base", "class", "NMTOKEN", null);
		attribute("basefont", "class", "NMTOKEN", null);
		attribute("bdo", "class", "NMTOKEN", null);
		attribute("bgsound", "class", "NMTOKEN", null);
		attribute("big", "class", "NMTOKEN", null);
		attribute("blink", "class", "NMTOKEN", null);
		attribute("blockquote", "class", "NMTOKEN", null);
		attribute("body", "class", "NMTOKEN", null);
		attribute("br", "class", "NMTOKEN", null);
		attribute("button", "class", "NMTOKEN", null);
		attribute("canvas", "class", "NMTOKEN", null);
		attribute("caption", "class", "NMTOKEN", null);
		attribute("center", "class", "NMTOKEN", null);
		attribute("cite", "class", "NMTOKEN", null);
		attribute("code", "class", "NMTOKEN", null);
		attribute("col", "class", "NMTOKEN", null);
		attribute("colgroup", "class", "NMTOKEN", null);
		attribute("comment", "class", "NMTOKEN", null);
		attribute("dd", "class", "NMTOKEN", null);
		attribute("del", "class", "NMTOKEN", null);
		attribute("dfn", "class", "NMTOKEN", null);
		attribute("dir", "class", "NMTOKEN", null);
		attribute("div", "class", "NMTOKEN", null);
		attribute("dl", "class", "NMTOKEN", null);
		attribute("dt", "class", "NMTOKEN", null);
		attribute("em", "class", "NMTOKEN", null);
		attribute("fieldset", "class", "NMTOKEN", null);
		attribute("font", "class", "NMTOKEN", null);
		attribute("form", "class", "NMTOKEN", null);
		attribute("frame", "class", "NMTOKEN", null);
		attribute("frameset", "class", "NMTOKEN", null);
		attribute("h1", "class", "NMTOKEN", null);
		attribute("h2", "class", "NMTOKEN", null);
		attribute("h3", "class", "NMTOKEN", null);
		attribute("h4", "class", "NMTOKEN", null);
		attribute("h5", "class", "NMTOKEN", null);
		attribute("h6", "class", "NMTOKEN", null);
		attribute("head", "class", "NMTOKEN", null);
		attribute("hr", "class", "NMTOKEN", null);
		attribute("html", "class", "NMTOKEN", null);
		attribute("i", "class", "NMTOKEN", null);
		attribute("iframe", "class", "NMTOKEN", null);
		attribute("img", "class", "NMTOKEN", null);
		attribute("input", "class", "NMTOKEN", null);
		attribute("ins", "class", "NMTOKEN", null);
		attribute("isindex", "class", "NMTOKEN", null);
		attribute("kbd", "class", "NMTOKEN", null);
		attribute("label", "class", "NMTOKEN", null);
		attribute("legend", "class", "NMTOKEN", null);
		attribute("li", "class", "NMTOKEN", null);
		attribute("link", "class", "NMTOKEN", null);
		attribute("listing", "class", "NMTOKEN", null);
		attribute("map", "class", "NMTOKEN", null);
		attribute("marquee", "class", "NMTOKEN", null);
		attribute("menu", "class", "NMTOKEN", null);
		attribute("meta", "class", "NMTOKEN", null);
		attribute("nobr", "class", "NMTOKEN", null);
		attribute("noframes", "class", "NMTOKEN", null);
		attribute("noscript", "class", "NMTOKEN", null);
		attribute("object", "class", "NMTOKEN", null);
		attribute("ol", "class", "NMTOKEN", null);
		attribute("optgroup", "class", "NMTOKEN", null);
		attribute("option", "class", "NMTOKEN", null);
		attribute("p", "class", "NMTOKEN", null);
		attribute("param", "class", "NMTOKEN", null);
		attribute("pre", "class", "NMTOKEN", null);
		attribute("q", "class", "NMTOKEN", null);
		attribute("rb", "class", "NMTOKEN", null);
		attribute("rbc", "class", "NMTOKEN", null);
		attribute("rp", "class", "NMTOKEN", null);
		attribute("rt", "class", "NMTOKEN", null);
		attribute("rtc", "class", "NMTOKEN", null);
		attribute("ruby", "class", "NMTOKEN", null);
		attribute("s", "class", "NMTOKEN", null);
		attribute("samp", "class", "NMTOKEN", null);
		attribute("script", "class", "NMTOKEN", null);
		attribute("select", "class", "NMTOKEN", null);
		attribute("small", "class", "NMTOKEN", null);
		attribute("span", "class", "NMTOKEN", null);
		attribute("strike", "class", "NMTOKEN", null);
		attribute("strong", "class", "NMTOKEN", null);
		attribute("style", "class", "NMTOKEN", null);
		attribute("sub", "class", "NMTOKEN", null);
		attribute("sup", "class", "NMTOKEN", null);
		attribute("table", "class", "NMTOKEN", null);
		attribute("tbody", "class", "NMTOKEN", null);
		attribute("td", "class", "NMTOKEN", null);
		attribute("textarea", "class", "NMTOKEN", null);
		attribute("tfoot", "class", "NMTOKEN", null);
		attribute("th", "class", "NMTOKEN", null);
		attribute("thead", "class", "NMTOKEN", null);
		attribute("title", "class", "NMTOKEN", null);
		attribute("tr", "class", "NMTOKEN", null);
		attribute("tt", "class", "NMTOKEN", null);
		attribute("u", "class", "NMTOKEN", null);
		attribute("ul", "class", "NMTOKEN", null);
		attribute("var", "class", "NMTOKEN", null);
		attribute("wbr", "class", "NMTOKEN", null);
		attribute("xmp", "class", "NMTOKEN", null);
		attribute("a", "dir", "NMTOKEN", null);
		attribute("abbr", "dir", "NMTOKEN", null);
		attribute("acronym", "dir", "NMTOKEN", null);
		attribute("address", "dir", "NMTOKEN", null);
		attribute("applet", "dir", "NMTOKEN", null);
		attribute("area", "dir", "NMTOKEN", null);
		attribute("b", "dir", "NMTOKEN", null);
		attribute("base", "dir", "NMTOKEN", null);
		attribute("basefont", "dir", "NMTOKEN", null);
		attribute("bdo", "dir", "NMTOKEN", null);
		attribute("bgsound", "dir", "NMTOKEN", null);
		attribute("big", "dir", "NMTOKEN", null);
		attribute("blink", "dir", "NMTOKEN", null);
		attribute("blockquote", "dir", "NMTOKEN", null);
		attribute("body", "dir", "NMTOKEN", null);
		attribute("br", "dir", "NMTOKEN", null);
		attribute("button", "dir", "NMTOKEN", null);
		attribute("canvas", "dir", "NMTOKEN", null);
		attribute("caption", "dir", "NMTOKEN", null);
		attribute("center", "dir", "NMTOKEN", null);
		attribute("cite", "dir", "NMTOKEN", null);
		attribute("code", "dir", "NMTOKEN", null);
		attribute("col", "dir", "NMTOKEN", null);
		attribute("colgroup", "dir", "NMTOKEN", null);
		attribute("comment", "dir", "NMTOKEN", null);
		attribute("dd", "dir", "NMTOKEN", null);
		attribute("del", "dir", "NMTOKEN", null);
		attribute("dfn", "dir", "NMTOKEN", null);
		attribute("dir", "dir", "NMTOKEN", null);
		attribute("div", "dir", "NMTOKEN", null);
		attribute("dl", "dir", "NMTOKEN", null);
		attribute("dt", "dir", "NMTOKEN", null);
		attribute("em", "dir", "NMTOKEN", null);
		attribute("fieldset", "dir", "NMTOKEN", null);
		attribute("font", "dir", "NMTOKEN", null);
		attribute("form", "dir", "NMTOKEN", null);
		attribute("frame", "dir", "NMTOKEN", null);
		attribute("frameset", "dir", "NMTOKEN", null);
		attribute("h1", "dir", "NMTOKEN", null);
		attribute("h2", "dir", "NMTOKEN", null);
		attribute("h3", "dir", "NMTOKEN", null);
		attribute("h4", "dir", "NMTOKEN", null);
		attribute("h5", "dir", "NMTOKEN", null);
		attribute("h6", "dir", "NMTOKEN", null);
		attribute("head", "dir", "NMTOKEN", null);
		attribute("hr", "dir", "NMTOKEN", null);
		attribute("html", "dir", "NMTOKEN", null);
		attribute("i", "dir", "NMTOKEN", null);
		attribute("iframe", "dir", "NMTOKEN", null);
		attribute("img", "dir", "NMTOKEN", null);
		attribute("input", "dir", "NMTOKEN", null);
		attribute("ins", "dir", "NMTOKEN", null);
		attribute("isindex", "dir", "NMTOKEN", null);
		attribute("kbd", "dir", "NMTOKEN", null);
		attribute("label", "dir", "NMTOKEN", null);
		attribute("legend", "dir", "NMTOKEN", null);
		attribute("li", "dir", "NMTOKEN", null);
		attribute("link", "dir", "NMTOKEN", null);
		attribute("listing", "dir", "NMTOKEN", null);
		attribute("map", "dir", "NMTOKEN", null);
		attribute("marquee", "dir", "NMTOKEN", null);
		attribute("menu", "dir", "NMTOKEN", null);
		attribute("meta", "dir", "NMTOKEN", null);
		attribute("nobr", "dir", "NMTOKEN", null);
		attribute("noframes", "dir", "NMTOKEN", null);
		attribute("noscript", "dir", "NMTOKEN", null);
		attribute("object", "dir", "NMTOKEN", null);
		attribute("ol", "dir", "NMTOKEN", null);
		attribute("optgroup", "dir", "NMTOKEN", null);
		attribute("option", "dir", "NMTOKEN", null);
		attribute("p", "dir", "NMTOKEN", null);
		attribute("param", "dir", "NMTOKEN", null);
		attribute("pre", "dir", "NMTOKEN", null);
		attribute("q", "dir", "NMTOKEN", null);
		attribute("rb", "dir", "NMTOKEN", null);
		attribute("rbc", "dir", "NMTOKEN", null);
		attribute("rp", "dir", "NMTOKEN", null);
		attribute("rt", "dir", "NMTOKEN", null);
		attribute("rtc", "dir", "NMTOKEN", null);
		attribute("ruby", "dir", "NMTOKEN", null);
		attribute("s", "dir", "NMTOKEN", null);
		attribute("samp", "dir", "NMTOKEN", null);
		attribute("script", "dir", "NMTOKEN", null);
		attribute("select", "dir", "NMTOKEN", null);
		attribute("small", "dir", "NMTOKEN", null);
		attribute("span", "dir", "NMTOKEN", null);
		attribute("strike", "dir", "NMTOKEN", null);
		attribute("strong", "dir", "NMTOKEN", null);
		attribute("style", "dir", "NMTOKEN", null);
		attribute("sub", "dir", "NMTOKEN", null);
		attribute("sup", "dir", "NMTOKEN", null);
		attribute("table", "dir", "NMTOKEN", null);
		attribute("tbody", "dir", "NMTOKEN", null);
		attribute("td", "dir", "NMTOKEN", null);
		attribute("textarea", "dir", "NMTOKEN", null);
		attribute("tfoot", "dir", "NMTOKEN", null);
		attribute("th", "dir", "NMTOKEN", null);
		attribute("thead", "dir", "NMTOKEN", null);
		attribute("title", "dir", "NMTOKEN", null);
		attribute("tr", "dir", "NMTOKEN", null);
		attribute("tt", "dir", "NMTOKEN", null);
		attribute("u", "dir", "NMTOKEN", null);
		attribute("ul", "dir", "NMTOKEN", null);
		attribute("var", "dir", "NMTOKEN", null);
		attribute("wbr", "dir", "NMTOKEN", null);
		attribute("xmp", "dir", "NMTOKEN", null);
		attribute("a", "id", "ID", null);
		attribute("abbr", "id", "ID", null);
		attribute("acronym", "id", "ID", null);
		attribute("address", "id", "ID", null);
		attribute("applet", "id", "ID", null);
		attribute("area", "id", "ID", null);
		attribute("b", "id", "ID", null);
		attribute("base", "id", "ID", null);
		attribute("basefont", "id", "ID", null);
		attribute("bdo", "id", "ID", null);
		attribute("bgsound", "id", "ID", null);
		attribute("big", "id", "ID", null);
		attribute("blink", "id", "ID", null);
		attribute("blockquote", "id", "ID", null);
		attribute("body", "id", "ID", null);
		attribute("br", "id", "ID", null);
		attribute("button", "id", "ID", null);
		attribute("canvas", "id", "ID", null);
		attribute("caption", "id", "ID", null);
		attribute("center", "id", "ID", null);
		attribute("cite", "id", "ID", null);
		attribute("code", "id", "ID", null);
		attribute("col", "id", "ID", null);
		attribute("colgroup", "id", "ID", null);
		attribute("comment", "id", "ID", null);
		attribute("dd", "id", "ID", null);
		attribute("del", "id", "ID", null);
		attribute("dfn", "id", "ID", null);
		attribute("dir", "id", "ID", null);
		attribute("div", "id", "ID", null);
		attribute("dl", "id", "ID", null);
		attribute("dt", "id", "ID", null);
		attribute("em", "id", "ID", null);
		attribute("fieldset", "id", "ID", null);
		attribute("font", "id", "ID", null);
		attribute("form", "id", "ID", null);
		attribute("frame", "id", "ID", null);
		attribute("frameset", "id", "ID", null);
		attribute("h1", "id", "ID", null);
		attribute("h2", "id", "ID", null);
		attribute("h3", "id", "ID", null);
		attribute("h4", "id", "ID", null);
		attribute("h5", "id", "ID", null);
		attribute("h6", "id", "ID", null);
		attribute("head", "id", "ID", null);
		attribute("hr", "id", "ID", null);
		attribute("html", "id", "ID", null);
		attribute("i", "id", "ID", null);
		attribute("iframe", "id", "ID", null);
		attribute("img", "id", "ID", null);
		attribute("input", "id", "ID", null);
		attribute("ins", "id", "ID", null);
		attribute("isindex", "id", "ID", null);
		attribute("kbd", "id", "ID", null);
		attribute("label", "id", "ID", null);
		attribute("legend", "id", "ID", null);
		attribute("li", "id", "ID", null);
		attribute("link", "id", "ID", null);
		attribute("listing", "id", "ID", null);
		attribute("map", "id", "ID", null);
		attribute("marquee", "id", "ID", null);
		attribute("menu", "id", "ID", null);
		attribute("meta", "id", "ID", null);
		attribute("nobr", "id", "ID", null);
		attribute("noframes", "id", "ID", null);
		attribute("noscript", "id", "ID", null);
		attribute("object", "id", "ID", null);
		attribute("ol", "id", "ID", null);
		attribute("optgroup", "id", "ID", null);
		attribute("option", "id", "ID", null);
		attribute("p", "id", "ID", null);
		attribute("param", "id", "ID", null);
		attribute("pre", "id", "ID", null);
		attribute("q", "id", "ID", null);
		attribute("rb", "id", "ID", null);
		attribute("rbc", "id", "ID", null);
		attribute("rp", "id", "ID", null);
		attribute("rt", "id", "ID", null);
		attribute("rtc", "id", "ID", null);
		attribute("ruby", "id", "ID", null);
		attribute("s", "id", "ID", null);
		attribute("samp", "id", "ID", null);
		attribute("script", "id", "ID", null);
		attribute("select", "id", "ID", null);
		attribute("small", "id", "ID", null);
		attribute("span", "id", "ID", null);
		attribute("strike", "id", "ID", null);
		attribute("strong", "id", "ID", null);
		attribute("style", "id", "ID", null);
		attribute("sub", "id", "ID", null);
		attribute("sup", "id", "ID", null);
		attribute("table", "id", "ID", null);
		attribute("tbody", "id", "ID", null);
		attribute("td", "id", "ID", null);
		attribute("textarea", "id", "ID", null);
		attribute("tfoot", "id", "ID", null);
		attribute("th", "id", "ID", null);
		attribute("thead", "id", "ID", null);
		attribute("title", "id", "ID", null);
		attribute("tr", "id", "ID", null);
		attribute("tt", "id", "ID", null);
		attribute("u", "id", "ID", null);
		attribute("ul", "id", "ID", null);
		attribute("var", "id", "ID", null);
		attribute("wbr", "id", "ID", null);
		attribute("xmp", "id", "ID", null);
		attribute("a", "lang", "NMTOKEN", null);
		attribute("abbr", "lang", "NMTOKEN", null);
		attribute("acronym", "lang", "NMTOKEN", null);
		attribute("address", "lang", "NMTOKEN", null);
		attribute("applet", "lang", "NMTOKEN", null);
		attribute("area", "lang", "NMTOKEN", null);
		attribute("b", "lang", "NMTOKEN", null);
		attribute("base", "lang", "NMTOKEN", null);
		attribute("basefont", "lang", "NMTOKEN", null);
		attribute("bdo", "lang", "NMTOKEN", null);
		attribute("bgsound", "lang", "NMTOKEN", null);
		attribute("big", "lang", "NMTOKEN", null);
		attribute("blink", "lang", "NMTOKEN", null);
		attribute("blockquote", "lang", "NMTOKEN", null);
		attribute("body", "lang", "NMTOKEN", null);
		attribute("br", "lang", "NMTOKEN", null);
		attribute("button", "lang", "NMTOKEN", null);
		attribute("canvas", "lang", "NMTOKEN", null);
		attribute("caption", "lang", "NMTOKEN", null);
		attribute("center", "lang", "NMTOKEN", null);
		attribute("cite", "lang", "NMTOKEN", null);
		attribute("code", "lang", "NMTOKEN", null);
		attribute("col", "lang", "NMTOKEN", null);
		attribute("colgroup", "lang", "NMTOKEN", null);
		attribute("comment", "lang", "NMTOKEN", null);
		attribute("dd", "lang", "NMTOKEN", null);
		attribute("del", "lang", "NMTOKEN", null);
		attribute("dfn", "lang", "NMTOKEN", null);
		attribute("dir", "lang", "NMTOKEN", null);
		attribute("div", "lang", "NMTOKEN", null);
		attribute("dl", "lang", "NMTOKEN", null);
		attribute("dt", "lang", "NMTOKEN", null);
		attribute("em", "lang", "NMTOKEN", null);
		attribute("fieldset", "lang", "NMTOKEN", null);
		attribute("font", "lang", "NMTOKEN", null);
		attribute("form", "lang", "NMTOKEN", null);
		attribute("frame", "lang", "NMTOKEN", null);
		attribute("frameset", "lang", "NMTOKEN", null);
		attribute("h1", "lang", "NMTOKEN", null);
		attribute("h2", "lang", "NMTOKEN", null);
		attribute("h3", "lang", "NMTOKEN", null);
		attribute("h4", "lang", "NMTOKEN", null);
		attribute("h5", "lang", "NMTOKEN", null);
		attribute("h6", "lang", "NMTOKEN", null);
		attribute("head", "lang", "NMTOKEN", null);
		attribute("hr", "lang", "NMTOKEN", null);
		attribute("html", "lang", "NMTOKEN", null);
		attribute("i", "lang", "NMTOKEN", null);
		attribute("iframe", "lang", "NMTOKEN", null);
		attribute("img", "lang", "NMTOKEN", null);
		attribute("input", "lang", "NMTOKEN", null);
		attribute("ins", "lang", "NMTOKEN", null);
		attribute("isindex", "lang", "NMTOKEN", null);
		attribute("kbd", "lang", "NMTOKEN", null);
		attribute("label", "lang", "NMTOKEN", null);
		attribute("legend", "lang", "NMTOKEN", null);
		attribute("li", "lang", "NMTOKEN", null);
		attribute("link", "lang", "NMTOKEN", null);
		attribute("listing", "lang", "NMTOKEN", null);
		attribute("map", "lang", "NMTOKEN", null);
		attribute("marquee", "lang", "NMTOKEN", null);
		attribute("menu", "lang", "NMTOKEN", null);
		attribute("meta", "lang", "NMTOKEN", null);
		attribute("nobr", "lang", "NMTOKEN", null);
		attribute("noframes", "lang", "NMTOKEN", null);
		attribute("noscript", "lang", "NMTOKEN", null);
		attribute("object", "lang", "NMTOKEN", null);
		attribute("ol", "lang", "NMTOKEN", null);
		attribute("optgroup", "lang", "NMTOKEN", null);
		attribute("option", "lang", "NMTOKEN", null);
		attribute("p", "lang", "NMTOKEN", null);
		attribute("param", "lang", "NMTOKEN", null);
		attribute("pre", "lang", "NMTOKEN", null);
		attribute("q", "lang", "NMTOKEN", null);
		attribute("rb", "lang", "NMTOKEN", null);
		attribute("rbc", "lang", "NMTOKEN", null);
		attribute("rp", "lang", "NMTOKEN", null);
		attribute("rt", "lang", "NMTOKEN", null);
		attribute("rtc", "lang", "NMTOKEN", null);
		attribute("ruby", "lang", "NMTOKEN", null);
		attribute("s", "lang", "NMTOKEN", null);
		attribute("samp", "lang", "NMTOKEN", null);
		attribute("script", "lang", "NMTOKEN", null);
		attribute("select", "lang", "NMTOKEN", null);
		attribute("small", "lang", "NMTOKEN", null);
		attribute("span", "lang", "NMTOKEN", null);
		attribute("strike", "lang", "NMTOKEN", null);
		attribute("strong", "lang", "NMTOKEN", null);
		attribute("style", "lang", "NMTOKEN", null);
		attribute("sub", "lang", "NMTOKEN", null);
		attribute("sup", "lang", "NMTOKEN", null);
		attribute("table", "lang", "NMTOKEN", null);
		attribute("tbody", "lang", "NMTOKEN", null);
		attribute("td", "lang", "NMTOKEN", null);
		attribute("textarea", "lang", "NMTOKEN", null);
		attribute("tfoot", "lang", "NMTOKEN", null);
		attribute("th", "lang", "NMTOKEN", null);
		attribute("thead", "lang", "NMTOKEN", null);
		attribute("title", "lang", "NMTOKEN", null);
		attribute("tr", "lang", "NMTOKEN", null);
		attribute("tt", "lang", "NMTOKEN", null);
		attribute("u", "lang", "NMTOKEN", null);
		attribute("ul", "lang", "NMTOKEN", null);
		attribute("var", "lang", "NMTOKEN", null);
		attribute("wbr", "lang", "NMTOKEN", null);
		attribute("xmp", "lang", "NMTOKEN", null);
		entity("aacgr", 0x03AC);
		entity("Aacgr", 0x0386);
		entity("aacute", 0x00E1);
		entity("Aacute", 0x00C1);
		entity("abreve", 0x0103);
		entity("Abreve", 0x0102);
		entity("ac", 0x223E);
		entity("acd", 0x223F);
		entity("acirc", 0x00E2);
		entity("Acirc", 0x00C2);
		entity("acute", 0x00B4);
		entity("acy", 0x0430);
		entity("Acy", 0x0410);
		entity("aelig", 0x00E6);
		entity("AElig", 0x00C6);
		entity("af", 0x2061);
		entity("afr", 0x1D51E);
		entity("Afr", 0x1D504);
		entity("agr", 0x03B1);
		entity("Agr", 0x0391);
		entity("agrave", 0x00E0);
		entity("Agrave", 0x00C0);
		entity("alefsym", 0x2135);
		entity("aleph", 0x2135);
		entity("alpha", 0x03B1);
		entity("Alpha", 0x0391);
		entity("amacr", 0x0101);
		entity("Amacr", 0x0100);
		entity("amalg", 0x2A3F);
		entity("amp", 0x0026);
		entity("AMP", 0x0026);
		entity("and", 0x2227);
		entity("And", 0x2A53);
		entity("andand", 0x2A55);
		entity("andd", 0x2A5C);
		entity("andslope", 0x2A58);
		entity("andv", 0x2A5A);
		entity("ang", 0x2220);
		entity("ange", 0x29A4);
		entity("angle", 0x2220);
		entity("angmsd", 0x2221);
		entity("angmsdaa", 0x29A8);
		entity("angmsdab", 0x29A9);
		entity("angmsdac", 0x29AA);
		entity("angmsdad", 0x29AB);
		entity("angmsdae", 0x29AC);
		entity("angmsdaf", 0x29AD);
		entity("angmsdag", 0x29AE);
		entity("angmsdah", 0x29AF);
		entity("angrt", 0x221F);
		entity("angrtvb", 0x22BE);
		entity("angrtvbd", 0x299D);
		entity("angsph", 0x2222);
		entity("angst", 0x00C5);
		entity("angzarr", 0x237C);
		entity("aogon", 0x0105);
		entity("Aogon", 0x0104);
		entity("aopf", 0x1D552);
		entity("Aopf", 0x1D538);
		entity("ap", 0x2248);
		entity("apacir", 0x2A6F);
		entity("ape", 0x224A);
		entity("apE", 0x2A70);
		entity("apid", 0x224B);
		entity("apos", 0x0027);
		entity("ApplyFunction", 0x2061);
		entity("approx", 0x2248);
		entity("approxeq", 0x224A);
		entity("aring", 0x00E5);
		entity("Aring", 0x00C5);
		entity("ascr", 0x1D4B6);
		entity("Ascr", 0x1D49C);
		entity("Assign", 0x2254);
		entity("ast", 0x002A);
		entity("asymp", 0x2248);
		entity("asympeq", 0x224D);
		entity("atilde", 0x00E3);
		entity("Atilde", 0x00C3);
		entity("auml", 0x00E4);
		entity("Auml", 0x00C4);
		entity("awconint", 0x2233);
		entity("awint", 0x2A11);
		entity("b.alpha", 0x1D6C2);
		entity("b.beta", 0x1D6C3);
		entity("b.chi", 0x1D6D8);
		entity("b.delta", 0x1D6C5);
		entity("b.Delta", 0x1D6AB);
		entity("b.epsi", 0x1D6C6);
		entity("b.epsiv", 0x1D6DC);
		entity("b.eta", 0x1D6C8);
		entity("b.gamma", 0x1D6C4);
		entity("b.Gamma", 0x1D6AA);
		entity("b.gammad", 0x1D7CB);
		entity("b.Gammad", 0x1D7CA);
		entity("b.iota", 0x1D6CA);
		entity("b.kappa", 0x1D6CB);
		entity("b.kappav", 0x1D6DE);
		entity("b.lambda", 0x1D6CC);
		entity("b.Lambda", 0x1D6B2);
		entity("b.mu", 0x1D6CD);
		entity("b.nu", 0x1D6CE);
		entity("b.omega", 0x1D6DA);
		entity("b.Omega", 0x1D6C0);
		entity("b.phi", 0x1D6D7);
		entity("b.Phi", 0x1D6BD);
		entity("b.phiv", 0x1D6DF);
		entity("b.pi", 0x1D6D1);
		entity("b.Pi", 0x1D6B7);
		entity("b.piv", 0x1D6E1);
		entity("b.psi", 0x1D6D9);
		entity("b.Psi", 0x1D6BF);
		entity("b.rho", 0x1D6D2);
		entity("b.rhov", 0x1D6E0);
		entity("b.sigma", 0x1D6D4);
		entity("b.Sigma", 0x1D6BA);
		entity("b.sigmav", 0x1D6D3);
		entity("b.tau", 0x1D6D5);
		entity("b.Theta", 0x1D6AF);
		entity("b.thetas", 0x1D6C9);
		entity("b.thetav", 0x1D6DD);
		entity("b.upsi", 0x1D6D6);
		entity("b.Upsi", 0x1D6BC);
		entity("b.xi", 0x1D6CF);
		entity("b.Xi", 0x1D6B5);
		entity("b.zeta", 0x1D6C7);
		entity("backcong", 0x224C);
		entity("backepsilon", 0x03F6);
		entity("backprime", 0x2035);
		entity("backsim", 0x223D);
		entity("backsimeq", 0x22CD);
		entity("Backslash", 0x2216);
		entity("Barv", 0x2AE7);
		entity("barvee", 0x22BD);
		entity("barwed", 0x2305);
		entity("Barwed", 0x2306);
		entity("barwedge", 0x2305);
		entity("bbrk", 0x23B5);
		entity("bbrktbrk", 0x23B6);
		entity("bcong", 0x224C);
		entity("bcy", 0x0431);
		entity("Bcy", 0x0411);
		entity("bdquo", 0x201E);
		entity("becaus", 0x2235);
		entity("because", 0x2235);
		entity("Because", 0x2235);
		entity("bemptyv", 0x29B0);
		entity("bepsi", 0x03F6);
		entity("bernou", 0x212C);
		entity("Bernoullis", 0x212C);
		entity("beta", 0x03B2);
		entity("Beta", 0x0392);
		entity("beth", 0x2136);
		entity("between", 0x226C);
		entity("bfr", 0x1D51F);
		entity("Bfr", 0x1D505);
		entity("bgr", 0x03B2);
		entity("Bgr", 0x0392);
		entity("bigcap", 0x22C2);
		entity("bigcirc", 0x25EF);
		entity("bigcup", 0x22C3);
		entity("bigodot", 0x2A00);
		entity("bigoplus", 0x2A01);
		entity("bigotimes", 0x2A02);
		entity("bigsqcup", 0x2A06);
		entity("bigstar", 0x2605);
		entity("bigtriangledown", 0x25BD);
		entity("bigtriangleup", 0x25B3);
		entity("biguplus", 0x2A04);
		entity("bigvee", 0x22C1);
		entity("bigwedge", 0x22C0);
		entity("bkarow", 0x290D);
		entity("blacklozenge", 0x29EB);
		entity("blacksquare", 0x25AA);
		entity("blacktriangle", 0x25B4);
		entity("blacktriangledown", 0x25BE);
		entity("blacktriangleleft", 0x25C2);
		entity("blacktriangleright", 0x25B8);
		entity("blank", 0x2423);
		entity("blk12", 0x2592);
		entity("blk14", 0x2591);
		entity("blk34", 0x2593);
		entity("block", 0x2588);
		entity("bnot", 0x2310);
		entity("bNot", 0x2AED);
		entity("bopf", 0x1D553);
		entity("Bopf", 0x1D539);
		entity("bot", 0x22A5);
		entity("bottom", 0x22A5);
		entity("bowtie", 0x22C8);
		entity("boxbox", 0x29C9);
		entity("boxdl", 0x2510);
		entity("boxdL", 0x2555);
		entity("boxDl", 0x2556);
		entity("boxDL", 0x2557);
		entity("boxdr", 0x250C);
		entity("boxdR", 0x2552);
		entity("boxDr", 0x2553);
		entity("boxDR", 0x2554);
		entity("boxh", 0x2500);
		entity("boxH", 0x2550);
		entity("boxhd", 0x252C);
		entity("boxhD", 0x2565);
		entity("boxHd", 0x2564);
		entity("boxHD", 0x2566);
		entity("boxhu", 0x2534);
		entity("boxhU", 0x2568);
		entity("boxHu", 0x2567);
		entity("boxHU", 0x2569);
		entity("boxminus", 0x229F);
		entity("boxplus", 0x229E);
		entity("boxtimes", 0x22A0);
		entity("boxul", 0x2518);
		entity("boxuL", 0x255B);
		entity("boxUl", 0x255C);
		entity("boxUL", 0x255D);
		entity("boxur", 0x2514);
		entity("boxuR", 0x2558);
		entity("boxUr", 0x2559);
		entity("boxUR", 0x255A);
		entity("boxv", 0x2502);
		entity("boxV", 0x2551);
		entity("boxvh", 0x253C);
		entity("boxvH", 0x256A);
		entity("boxVh", 0x256B);
		entity("boxVH", 0x256C);
		entity("boxvl", 0x2524);
		entity("boxvL", 0x2561);
		entity("boxVl", 0x2562);
		entity("boxVL", 0x2563);
		entity("boxvr", 0x251C);
		entity("boxvR", 0x255E);
		entity("boxVr", 0x255F);
		entity("boxVR", 0x2560);
		entity("bprime", 0x2035);
		entity("breve", 0x02D8);
		entity("Breve", 0x02D8);
		entity("brvbar", 0x00A6);
		entity("bscr", 0x1D4B7);
		entity("Bscr", 0x212C);
		entity("bsemi", 0x204F);
		entity("bsim", 0x223D);
		entity("bsime", 0x22CD);
		entity("bsol", 0x005C);
		entity("bsolb", 0x29C5);
		entity("bsolhsub", 0x27C8);
		entity("bull", 0x2022);
		entity("bullet", 0x2022);
		entity("bump", 0x224E);
		entity("bumpe", 0x224F);
		entity("bumpE", 0x2AAE);
		entity("bumpeq", 0x224F);
		entity("Bumpeq", 0x224E);
		entity("cacute", 0x0107);
		entity("Cacute", 0x0106);
		entity("cap", 0x2229);
		entity("Cap", 0x22D2);
		entity("capand", 0x2A44);
		entity("capbrcup", 0x2A49);
		entity("capcap", 0x2A4B);
		entity("capcup", 0x2A47);
		entity("capdot", 0x2A40);
		entity("CapitalDifferentialD", 0x2145);
		entity("caret", 0x2041);
		entity("caron", 0x02C7);
		entity("Cayleys", 0x212D);
		entity("ccaps", 0x2A4D);
		entity("ccaron", 0x010D);
		entity("Ccaron", 0x010C);
		entity("ccedil", 0x00E7);
		entity("Ccedil", 0x00C7);
		entity("ccirc", 0x0109);
		entity("Ccirc", 0x0108);
		entity("Cconint", 0x2230);
		entity("ccups", 0x2A4C);
		entity("ccupssm", 0x2A50);
		entity("cdot", 0x010B);
		entity("Cdot", 0x010A);
		entity("cedil", 0x00B8);
		entity("Cedilla", 0x00B8);
		entity("cemptyv", 0x29B2);
		entity("cent", 0x00A2);
		entity("centerdot", 0x00B7);
		entity("CenterDot", 0x00B7);
		entity("cfr", 0x1D520);
		entity("Cfr", 0x212D);
		entity("chcy", 0x0447);
		entity("CHcy", 0x0427);
		entity("check", 0x2713);
		entity("checkmark", 0x2713);
		entity("chi", 0x03C7);
		entity("Chi", 0x03A7);
		entity("cir", 0x25CB);
		entity("circ", 0x02C6);
		entity("circeq", 0x2257);
		entity("circlearrowleft", 0x21BA);
		entity("circlearrowright", 0x21BB);
		entity("circledast", 0x229B);
		entity("circledcirc", 0x229A);
		entity("circleddash", 0x229D);
		entity("CircleDot", 0x2299);
		entity("circledR", 0x00AE);
		entity("circledS", 0x24C8);
		entity("CircleMinus", 0x2296);
		entity("CirclePlus", 0x2295);
		entity("CircleTimes", 0x2297);
		entity("cire", 0x2257);
		entity("cirE", 0x29C3);
		entity("cirfnint", 0x2A10);
		entity("cirmid", 0x2AEF);
		entity("cirscir", 0x29C2);
		entity("ClockwiseContourIntegral", 0x2232);
		entity("CloseCurlyDoubleQuote", 0x201D);
		entity("CloseCurlyQuote", 0x2019);
		entity("clubs", 0x2663);
		entity("clubsuit", 0x2663);
		entity("colon", 0x003A);
		entity("Colon", 0x2237);
		entity("colone", 0x2254);
		entity("Colone", 0x2A74);
		entity("coloneq", 0x2254);
		entity("comma", 0x002C);
		entity("commat", 0x0040);
		entity("comp", 0x2201);
		entity("compfn", 0x2218);
		entity("complement", 0x2201);
		entity("complexes", 0x2102);
		entity("cong", 0x2245);
		entity("congdot", 0x2A6D);
		entity("Congruent", 0x2261);
		entity("conint", 0x222E);
		entity("Conint", 0x222F);
		entity("ContourIntegral", 0x222E);
		entity("copf", 0x1D554);
		entity("Copf", 0x2102);
		entity("coprod", 0x2210);
		entity("Coproduct", 0x2210);
		entity("copy", 0x00A9);
		entity("COPY", 0x00A9);
		entity("copysr", 0x2117);
		entity("CounterClockwiseContourIntegral", 0x2233);
		entity("crarr", 0x21B5);
		entity("cross", 0x2717);
		entity("Cross", 0x2A2F);
		entity("cscr", 0x1D4B8);
		entity("Cscr", 0x1D49E);
		entity("csub", 0x2ACF);
		entity("csube", 0x2AD1);
		entity("csup", 0x2AD0);
		entity("csupe", 0x2AD2);
		entity("ctdot", 0x22EF);
		entity("cudarrl", 0x2938);
		entity("cudarrr", 0x2935);
		entity("cuepr", 0x22DE);
		entity("cuesc", 0x22DF);
		entity("cularr", 0x21B6);
		entity("cularrp", 0x293D);
		entity("cup", 0x222A);
		entity("Cup", 0x22D3);
		entity("cupbrcap", 0x2A48);
		entity("cupcap", 0x2A46);
		entity("CupCap", 0x224D);
		entity("cupcup", 0x2A4A);
		entity("cupdot", 0x228D);
		entity("cupor", 0x2A45);
		entity("curarr", 0x21B7);
		entity("curarrm", 0x293C);
		entity("curlyeqprec", 0x22DE);
		entity("curlyeqsucc", 0x22DF);
		entity("curlyvee", 0x22CE);
		entity("curlywedge", 0x22CF);
		entity("curren", 0x00A4);
		entity("curvearrowleft", 0x21B6);
		entity("curvearrowright", 0x21B7);
		entity("cuvee", 0x22CE);
		entity("cuwed", 0x22CF);
		entity("cwconint", 0x2232);
		entity("cwint", 0x2231);
		entity("cylcty", 0x232D);
		entity("dagger", 0x2020);
		entity("Dagger", 0x2021);
		entity("daleth", 0x2138);
		entity("darr", 0x2193);
		entity("dArr", 0x21D3);
		entity("Darr", 0x21A1);
		entity("dash", 0x2010);
		entity("dashv", 0x22A3);
		entity("Dashv", 0x2AE4);
		entity("dbkarow", 0x290F);
		entity("dblac", 0x02DD);
		entity("dcaron", 0x010F);
		entity("Dcaron", 0x010E);
		entity("dcy", 0x0434);
		entity("Dcy", 0x0414);
		entity("dd", 0x2146);
		entity("DD", 0x2145);
		entity("ddagger", 0x2021);
		entity("ddarr", 0x21CA);
		entity("DDotrahd", 0x2911);
		entity("ddotseq", 0x2A77);
		entity("deg", 0x00B0);
		entity("Del", 0x2207);
		entity("delta", 0x03B4);
		entity("Delta", 0x0394);
		entity("demptyv", 0x29B1);
		entity("dfisht", 0x297F);
		entity("dfr", 0x1D521);
		entity("Dfr", 0x1D507);
		entity("dgr", 0x03B4);
		entity("Dgr", 0x0394);
		entity("dHar", 0x2965);
		entity("dharl", 0x21C3);
		entity("dharr", 0x21C2);
		entity("DiacriticalAcute", 0x00B4);
		entity("DiacriticalDot", 0x02D9);
		entity("DiacriticalDoubleAcute", 0x02DD);
		entity("DiacriticalGrave", 0x0060);
		entity("DiacriticalTilde", 0x02DC);
		entity("diam", 0x22C4);
		entity("diamond", 0x22C4);
		entity("Diamond", 0x22C4);
		entity("diamondsuit", 0x2666);
		entity("diams", 0x2666);
		entity("die", 0x00A8);
		entity("DifferentialD", 0x2146);
		entity("digamma", 0x03DD);
		entity("disin", 0x22F2);
		entity("div", 0x00F7);
		entity("divide", 0x00F7);
		entity("divideontimes", 0x22C7);
		entity("divonx", 0x22C7);
		entity("djcy", 0x0452);
		entity("DJcy", 0x0402);
		entity("dlcorn", 0x231E);
		entity("dlcrop", 0x230D);
		entity("dollar", 0x0024);
		entity("dopf", 0x1D555);
		entity("Dopf", 0x1D53B);
		entity("dot", 0x02D9);
		entity("Dot", 0x00A8);
		entity("doteq", 0x2250);
		entity("doteqdot", 0x2251);
		entity("DotEqual", 0x2250);
		entity("dotminus", 0x2238);
		entity("dotplus", 0x2214);
		entity("dotsquare", 0x22A1);
		entity("doublebarwedge", 0x2306);
		entity("DoubleContourIntegral", 0x222F);
		entity("DoubleDot", 0x00A8);
		entity("DoubleDownArrow", 0x21D3);
		entity("DoubleLeftArrow", 0x21D0);
		entity("DoubleLeftRightArrow", 0x21D4);
		entity("DoubleLeftTee", 0x2AE4);
		entity("DoubleLongLeftArrow", 0x27F8);
		entity("DoubleLongLeftRightArrow", 0x27FA);
		entity("DoubleLongRightArrow", 0x27F9);
		entity("DoubleRightArrow", 0x21D2);
		entity("DoubleRightTee", 0x22A8);
		entity("DoubleUpArrow", 0x21D1);
		entity("DoubleUpDownArrow", 0x21D5);
		entity("DoubleVerticalBar", 0x2225);
		entity("downarrow", 0x2193);
		entity("Downarrow", 0x21D3);
		entity("DownArrow", 0x2193);
		entity("DownArrowBar", 0x2913);
		entity("DownArrowUpArrow", 0x21F5);
		entity("downdownarrows", 0x21CA);
		entity("downharpoonleft", 0x21C3);
		entity("downharpoonright", 0x21C2);
		entity("DownLeftRightVector", 0x2950);
		entity("DownLeftTeeVector", 0x295E);
		entity("DownLeftVector", 0x21BD);
		entity("DownLeftVectorBar", 0x2956);
		entity("DownRightTeeVector", 0x295F);
		entity("DownRightVector", 0x21C1);
		entity("DownRightVectorBar", 0x2957);
		entity("DownTee", 0x22A4);
		entity("DownTeeArrow", 0x21A7);
		entity("drbkarow", 0x2910);
		entity("drcorn", 0x231F);
		entity("drcrop", 0x230C);
		entity("dscr", 0x1D4B9);
		entity("Dscr", 0x1D49F);
		entity("dscy", 0x0455);
		entity("DScy", 0x0405);
		entity("dsol", 0x29F6);
		entity("dstrok", 0x0111);
		entity("Dstrok", 0x0110);
		entity("dtdot", 0x22F1);
		entity("dtri", 0x25BF);
		entity("dtrif", 0x25BE);
		entity("duarr", 0x21F5);
		entity("duhar", 0x296F);
		entity("dwangle", 0x29A6);
		entity("dzcy", 0x045F);
		entity("DZcy", 0x040F);
		entity("dzigrarr", 0x27FF);
		entity("eacgr", 0x03AD);
		entity("Eacgr", 0x0388);
		entity("eacute", 0x00E9);
		entity("Eacute", 0x00C9);
		entity("easter", 0x2A6E);
		entity("ecaron", 0x011B);
		entity("Ecaron", 0x011A);
		entity("ecir", 0x2256);
		entity("ecirc", 0x00EA);
		entity("Ecirc", 0x00CA);
		entity("ecolon", 0x2255);
		entity("ecy", 0x044D);
		entity("Ecy", 0x042D);
		entity("eDDot", 0x2A77);
		entity("edot", 0x0117);
		entity("eDot", 0x2251);
		entity("Edot", 0x0116);
		entity("ee", 0x2147);
		entity("eeacgr", 0x03AE);
		entity("EEacgr", 0x0389);
		entity("eegr", 0x03B7);
		entity("EEgr", 0x0397);
		entity("efDot", 0x2252);
		entity("efr", 0x1D522);
		entity("Efr", 0x1D508);
		entity("eg", 0x2A9A);
		entity("egr", 0x03B5);
		entity("Egr", 0x0395);
		entity("egrave", 0x00E8);
		entity("Egrave", 0x00C8);
		entity("egs", 0x2A96);
		entity("egsdot", 0x2A98);
		entity("el", 0x2A99);
		entity("Element", 0x2208);
		entity("elinters", 0x23E7);
		entity("ell", 0x2113);
		entity("els", 0x2A95);
		entity("elsdot", 0x2A97);
		entity("emacr", 0x0113);
		entity("Emacr", 0x0112);
		entity("empty", 0x2205);
		entity("emptyset", 0x2205);
		entity("EmptySmallSquare", 0x25FB);
		entity("emptyv", 0x2205);
		entity("EmptyVerySmallSquare", 0x25AB);
		entity("emsp", 0x2003);
		entity("emsp13", 0x2004);
		entity("emsp14", 0x2005);
		entity("eng", 0x014B);
		entity("ENG", 0x014A);
		entity("ensp", 0x2002);
		entity("eogon", 0x0119);
		entity("Eogon", 0x0118);
		entity("eopf", 0x1D556);
		entity("Eopf", 0x1D53C);
		entity("epar", 0x22D5);
		entity("eparsl", 0x29E3);
		entity("eplus", 0x2A71);
		entity("epsi", 0x03B5);
		entity("epsilon", 0x03B5);
		entity("Epsilon", 0x0395);
		entity("epsiv", 0x03F5);
		entity("eqcirc", 0x2256);
		entity("eqcolon", 0x2255);
		entity("eqsim", 0x2242);
		entity("eqslantgtr", 0x2A96);
		entity("eqslantless", 0x2A95);
		entity("Equal", 0x2A75);
		entity("equals", 0x003D);
		entity("EqualTilde", 0x2242);
		entity("equest", 0x225F);
		entity("Equilibrium", 0x21CC);
		entity("equiv", 0x2261);
		entity("equivDD", 0x2A78);
		entity("eqvparsl", 0x29E5);
		entity("erarr", 0x2971);
		entity("erDot", 0x2253);
		entity("escr", 0x212F);
		entity("Escr", 0x2130);
		entity("esdot", 0x2250);
		entity("esim", 0x2242);
		entity("Esim", 0x2A73);
		entity("eta", 0x03B7);
		entity("Eta", 0x0397);
		entity("eth", 0x00F0);
		entity("ETH", 0x00D0);
		entity("euml", 0x00EB);
		entity("Euml", 0x00CB);
		entity("euro", 0x20AC);
		entity("excl", 0x0021);
		entity("exist", 0x2203);
		entity("Exists", 0x2203);
		entity("expectation", 0x2130);
		entity("exponentiale", 0x2147);
		entity("ExponentialE", 0x2147);
		entity("fallingdotseq", 0x2252);
		entity("fcy", 0x0444);
		entity("Fcy", 0x0424);
		entity("female", 0x2640);
		entity("ffilig", 0xFB03);
		entity("fflig", 0xFB00);
		entity("ffllig", 0xFB04);
		entity("ffr", 0x1D523);
		entity("Ffr", 0x1D509);
		entity("filig", 0xFB01);
		entity("FilledSmallSquare", 0x25FC);
		entity("FilledVerySmallSquare", 0x25AA);
		entity("flat", 0x266D);
		entity("fllig", 0xFB02);
		entity("fltns", 0x25B1);
		entity("fnof", 0x0192);
		entity("fopf", 0x1D557);
		entity("Fopf", 0x1D53D);
		entity("forall", 0x2200);
		entity("ForAll", 0x2200);
		entity("fork", 0x22D4);
		entity("forkv", 0x2AD9);
		entity("Fouriertrf", 0x2131);
		entity("fpartint", 0x2A0D);
		entity("frac12", 0x00BD);
		entity("frac13", 0x2153);
		entity("frac14", 0x00BC);
		entity("frac15", 0x2155);
		entity("frac16", 0x2159);
		entity("frac18", 0x215B);
		entity("frac23", 0x2154);
		entity("frac25", 0x2156);
		entity("frac34", 0x00BE);
		entity("frac35", 0x2157);
		entity("frac38", 0x215C);
		entity("frac45", 0x2158);
		entity("frac56", 0x215A);
		entity("frac58", 0x215D);
		entity("frac78", 0x215E);
		entity("frasl", 0x2044);
		entity("frown", 0x2322);
		entity("fscr", 0x1D4BB);
		entity("Fscr", 0x2131);
		entity("gacute", 0x01F5);
		entity("gamma", 0x03B3);
		entity("Gamma", 0x0393);
		entity("gammad", 0x03DD);
		entity("Gammad", 0x03DC);
		entity("gap", 0x2A86);
		entity("gbreve", 0x011F);
		entity("Gbreve", 0x011E);
		entity("Gcedil", 0x0122);
		entity("gcirc", 0x011D);
		entity("Gcirc", 0x011C);
		entity("gcy", 0x0433);
		entity("Gcy", 0x0413);
		entity("gdot", 0x0121);
		entity("Gdot", 0x0120);
		entity("ge", 0x2265);
		entity("gE", 0x2267);
		entity("gel", 0x22DB);
		entity("gEl", 0x2A8C);
		entity("geq", 0x2265);
		entity("geqq", 0x2267);
		entity("geqslant", 0x2A7E);
		entity("ges", 0x2A7E);
		entity("gescc", 0x2AA9);
		entity("gesdot", 0x2A80);
		entity("gesdoto", 0x2A82);
		entity("gesdotol", 0x2A84);
		entity("gesles", 0x2A94);
		entity("gfr", 0x1D524);
		entity("Gfr", 0x1D50A);
		entity("gg", 0x226B);
		entity("Gg", 0x22D9);
		entity("ggg", 0x22D9);
		entity("ggr", 0x03B3);
		entity("Ggr", 0x0393);
		entity("gimel", 0x2137);
		entity("gjcy", 0x0453);
		entity("GJcy", 0x0403);
		entity("gl", 0x2277);
		entity("gla", 0x2AA5);
		entity("glE", 0x2A92);
		entity("glj", 0x2AA4);
		entity("gnap", 0x2A8A);
		entity("gnapprox", 0x2A8A);
		entity("gne", 0x2A88);
		entity("gnE", 0x2269);
		entity("gneq", 0x2A88);
		entity("gneqq", 0x2269);
		entity("gnsim", 0x22E7);
		entity("gopf", 0x1D558);
		entity("Gopf", 0x1D53E);
		entity("grave", 0x0060);
		entity("GreaterEqual", 0x2265);
		entity("GreaterEqualLess", 0x22DB);
		entity("GreaterFullEqual", 0x2267);
		entity("GreaterGreater", 0x2AA2);
		entity("GreaterLess", 0x2277);
		entity("GreaterSlantEqual", 0x2A7E);
		entity("GreaterTilde", 0x2273);
		entity("gscr", 0x210A);
		entity("Gscr", 0x1D4A2);
		entity("gsim", 0x2273);
		entity("gsime", 0x2A8E);
		entity("gsiml", 0x2A90);
		entity("gt", 0x003E);
		entity("Gt", 0x226B);
		entity("GT", 0x003E);
		entity("gtcc", 0x2AA7);
		entity("gtcir", 0x2A7A);
		entity("gtdot", 0x22D7);
		entity("gtlPar", 0x2995);
		entity("gtquest", 0x2A7C);
		entity("gtrapprox", 0x2A86);
		entity("gtrarr", 0x2978);
		entity("gtrdot", 0x22D7);
		entity("gtreqless", 0x22DB);
		entity("gtreqqless", 0x2A8C);
		entity("gtrless", 0x2277);
		entity("gtrsim", 0x2273);
		entity("Hacek", 0x02C7);
		entity("hairsp", 0x200A);
		entity("half", 0x00BD);
		entity("hamilt", 0x210B);
		entity("hardcy", 0x044A);
		entity("HARDcy", 0x042A);
		entity("harr", 0x2194);
		entity("hArr", 0x21D4);
		entity("harrcir", 0x2948);
		entity("harrw", 0x21AD);
		entity("Hat", 0x005E);
		entity("hbar", 0x210F);
		entity("hcirc", 0x0125);
		entity("Hcirc", 0x0124);
		entity("hearts", 0x2665);
		entity("heartsuit", 0x2665);
		entity("hellip", 0x2026);
		entity("hercon", 0x22B9);
		entity("hfr", 0x1D525);
		entity("Hfr", 0x210C);
		entity("HilbertSpace", 0x210B);
		entity("hksearow", 0x2925);
		entity("hkswarow", 0x2926);
		entity("hoarr", 0x21FF);
		entity("homtht", 0x223B);
		entity("hookleftarrow", 0x21A9);
		entity("hookrightarrow", 0x21AA);
		entity("hopf", 0x1D559);
		entity("Hopf", 0x210D);
		entity("horbar", 0x2015);
		entity("HorizontalLine", 0x2500);
		entity("hscr", 0x1D4BD);
		entity("Hscr", 0x210B);
		entity("hslash", 0x210F);
		entity("hstrok", 0x0127);
		entity("Hstrok", 0x0126);
		entity("HumpDownHump", 0x224E);
		entity("HumpEqual", 0x224F);
		entity("hybull", 0x2043);
		entity("hyphen", 0x2010);
		entity("iacgr", 0x03AF);
		entity("Iacgr", 0x038A);
		entity("iacute", 0x00ED);
		entity("Iacute", 0x00CD);
		entity("ic", 0x2063);
		entity("icirc", 0x00EE);
		entity("Icirc", 0x00CE);
		entity("icy", 0x0438);
		entity("Icy", 0x0418);
		entity("idiagr", 0x0390);
		entity("idigr", 0x03CA);
		entity("Idigr", 0x03AA);
		entity("Idot", 0x0130);
		entity("iecy", 0x0435);
		entity("IEcy", 0x0415);
		entity("iexcl", 0x00A1);
		entity("iff", 0x21D4);
		entity("ifr", 0x1D526);
		entity("Ifr", 0x2111);
		entity("igr", 0x03B9);
		entity("Igr", 0x0399);
		entity("igrave", 0x00EC);
		entity("Igrave", 0x00CC);
		entity("ii", 0x2148);
		entity("iiiint", 0x2A0C);
		entity("iiint", 0x222D);
		entity("iinfin", 0x29DC);
		entity("iiota", 0x2129);
		entity("ijlig", 0x0133);
		entity("IJlig", 0x0132);
		entity("Im", 0x2111);
		entity("imacr", 0x012B);
		entity("Imacr", 0x012A);
		entity("image", 0x2111);
		entity("ImaginaryI", 0x2148);
		entity("imagline", 0x2110);
		entity("imagpart", 0x2111);
		entity("imath", 0x0131);
		entity("imof", 0x22B7);
		entity("imped", 0x01B5);
		entity("Implies", 0x21D2);
		entity("in", 0x2208);
		entity("incare", 0x2105);
		entity("infin", 0x221E);
		entity("infintie", 0x29DD);
		entity("inodot", 0x0131);
		entity("int", 0x222B);
		entity("Int", 0x222C);
		entity("intcal", 0x22BA);
		entity("integers", 0x2124);
		entity("Integral", 0x222B);
		entity("intercal", 0x22BA);
		entity("Intersection", 0x22C2);
		entity("intlarhk", 0x2A17);
		entity("intprod", 0x2A3C);
		entity("InvisibleComma", 0x2063);
		entity("InvisibleTimes", 0x2062);
		entity("iocy", 0x0451);
		entity("IOcy", 0x0401);
		entity("iogon", 0x012F);
		entity("Iogon", 0x012E);
		entity("iopf", 0x1D55A);
		entity("Iopf", 0x1D540);
		entity("iota", 0x03B9);
		entity("Iota", 0x0399);
		entity("iprod", 0x2A3C);
		entity("iquest", 0x00BF);
		entity("iscr", 0x1D4BE);
		entity("Iscr", 0x2110);
		entity("isin", 0x2208);
		entity("isindot", 0x22F5);
		entity("isinE", 0x22F9);
		entity("isins", 0x22F4);
		entity("isinsv", 0x22F3);
		entity("isinv", 0x2208);
		entity("it", 0x2062);
		entity("itilde", 0x0129);
		entity("Itilde", 0x0128);
		entity("iukcy", 0x0456);
		entity("Iukcy", 0x0406);
		entity("iuml", 0x00EF);
		entity("Iuml", 0x00CF);
		entity("jcirc", 0x0135);
		entity("Jcirc", 0x0134);
		entity("jcy", 0x0439);
		entity("Jcy", 0x0419);
		entity("jfr", 0x1D527);
		entity("Jfr", 0x1D50D);
		entity("jmath", 0x0237);
		entity("jopf", 0x1D55B);
		entity("Jopf", 0x1D541);
		entity("jscr", 0x1D4BF);
		entity("Jscr", 0x1D4A5);
		entity("jsercy", 0x0458);
		entity("Jsercy", 0x0408);
		entity("jukcy", 0x0454);
		entity("Jukcy", 0x0404);
		entity("kappa", 0x03BA);
		entity("Kappa", 0x039A);
		entity("kappav", 0x03F0);
		entity("kcedil", 0x0137);
		entity("Kcedil", 0x0136);
		entity("kcy", 0x043A);
		entity("Kcy", 0x041A);
		entity("kfr", 0x1D528);
		entity("Kfr", 0x1D50E);
		entity("kgr", 0x03BA);
		entity("Kgr", 0x039A);
		entity("kgreen", 0x0138);
		entity("khcy", 0x0445);
		entity("KHcy", 0x0425);
		entity("khgr", 0x03C7);
		entity("KHgr", 0x03A7);
		entity("kjcy", 0x045C);
		entity("KJcy", 0x040C);
		entity("kopf", 0x1D55C);
		entity("Kopf", 0x1D542);
		entity("kscr", 0x1D4C0);
		entity("Kscr", 0x1D4A6);
		entity("lAarr", 0x21DA);
		entity("lacute", 0x013A);
		entity("Lacute", 0x0139);
		entity("laemptyv", 0x29B4);
		entity("lagran", 0x2112);
		entity("lambda", 0x03BB);
		entity("Lambda", 0x039B);
		entity("lang", 0x27E8);
		entity("Lang", 0x27EA);
		entity("langd", 0x2991);
		entity("langle", 0x27E8);
		entity("lap", 0x2A85);
		entity("Laplacetrf", 0x2112);
		entity("laquo", 0x00AB);
		entity("larr", 0x2190);
		entity("lArr", 0x21D0);
		entity("Larr", 0x219E);
		entity("larrb", 0x21E4);
		entity("larrbfs", 0x291F);
		entity("larrfs", 0x291D);
		entity("larrhk", 0x21A9);
		entity("larrlp", 0x21AB);
		entity("larrpl", 0x2939);
		entity("larrsim", 0x2973);
		entity("larrtl", 0x21A2);
		entity("lat", 0x2AAB);
		entity("latail", 0x2919);
		entity("lAtail", 0x291B);
		entity("late", 0x2AAD);
		entity("lbarr", 0x290C);
		entity("lBarr", 0x290E);
		entity("lbbrk", 0x2772);
		entity("lbrace", 0x007B);
		entity("lbrack", 0x005B);
		entity("lbrke", 0x298B);
		entity("lbrksld", 0x298F);
		entity("lbrkslu", 0x298D);
		entity("lcaron", 0x013E);
		entity("Lcaron", 0x013D);
		entity("lcedil", 0x013C);
		entity("Lcedil", 0x013B);
		entity("lceil", 0x2308);
		entity("lcub", 0x007B);
		entity("lcy", 0x043B);
		entity("Lcy", 0x041B);
		entity("ldca", 0x2936);
		entity("ldquo", 0x201C);
		entity("ldquor", 0x201E);
		entity("ldrdhar", 0x2967);
		entity("ldrushar", 0x294B);
		entity("ldsh", 0x21B2);
		entity("le", 0x2264);
		entity("lE", 0x2266);
		entity("LeftAngleBracket", 0x27E8);
		entity("leftarrow", 0x2190);
		entity("Leftarrow", 0x21D0);
		entity("LeftArrow", 0x2190);
		entity("LeftArrowBar", 0x21E4);
		entity("LeftArrowRightArrow", 0x21C6);
		entity("leftarrowtail", 0x21A2);
		entity("LeftCeiling", 0x2308);
		entity("LeftDoubleBracket", 0x27E6);
		entity("LeftDownTeeVector", 0x2961);
		entity("LeftDownVector", 0x21C3);
		entity("LeftDownVectorBar", 0x2959);
		entity("LeftFloor", 0x230A);
		entity("leftharpoondown", 0x21BD);
		entity("leftharpoonup", 0x21BC);
		entity("leftleftarrows", 0x21C7);
		entity("leftrightarrow", 0x2194);
		entity("Leftrightarrow", 0x21D4);
		entity("LeftRightArrow", 0x2194);
		entity("leftrightarrows", 0x21C6);
		entity("leftrightharpoons", 0x21CB);
		entity("leftrightsquigarrow", 0x21AD);
		entity("LeftRightVector", 0x294E);
		entity("LeftTee", 0x22A3);
		entity("LeftTeeArrow", 0x21A4);
		entity("LeftTeeVector", 0x295A);
		entity("leftthreetimes", 0x22CB);
		entity("LeftTriangle", 0x22B2);
		entity("LeftTriangleBar", 0x29CF);
		entity("LeftTriangleEqual", 0x22B4);
		entity("LeftUpDownVector", 0x2951);
		entity("LeftUpTeeVector", 0x2960);
		entity("LeftUpVector", 0x21BF);
		entity("LeftUpVectorBar", 0x2958);
		entity("LeftVector", 0x21BC);
		entity("LeftVectorBar", 0x2952);
		entity("leg", 0x22DA);
		entity("lEg", 0x2A8B);
		entity("leq", 0x2264);
		entity("leqq", 0x2266);
		entity("leqslant", 0x2A7D);
		entity("les", 0x2A7D);
		entity("lescc", 0x2AA8);
		entity("lesdot", 0x2A7F);
		entity("lesdoto", 0x2A81);
		entity("lesdotor", 0x2A83);
		entity("lesges", 0x2A93);
		entity("lessapprox", 0x2A85);
		entity("lessdot", 0x22D6);
		entity("lesseqgtr", 0x22DA);
		entity("lesseqqgtr", 0x2A8B);
		entity("LessEqualGreater", 0x22DA);
		entity("LessFullEqual", 0x2266);
		entity("LessGreater", 0x2276);
		entity("lessgtr", 0x2276);
		entity("LessLess", 0x2AA1);
		entity("lesssim", 0x2272);
		entity("LessSlantEqual", 0x2A7D);
		entity("LessTilde", 0x2272);
		entity("lfisht", 0x297C);
		entity("lfloor", 0x230A);
		entity("lfr", 0x1D529);
		entity("Lfr", 0x1D50F);
		entity("lg", 0x2276);
		entity("lgE", 0x2A91);
		entity("lgr", 0x03BB);
		entity("Lgr", 0x039B);
		entity("lHar", 0x2962);
		entity("lhard", 0x21BD);
		entity("lharu", 0x21BC);
		entity("lharul", 0x296A);
		entity("lhblk", 0x2584);
		entity("ljcy", 0x0459);
		entity("LJcy", 0x0409);
		entity("ll", 0x226A);
		entity("Ll", 0x22D8);
		entity("llarr", 0x21C7);
		entity("llcorner", 0x231E);
		entity("Lleftarrow", 0x21DA);
		entity("llhard", 0x296B);
		entity("lltri", 0x25FA);
		entity("lmidot", 0x0140);
		entity("Lmidot", 0x013F);
		entity("lmoust", 0x23B0);
		entity("lmoustache", 0x23B0);
		entity("lnap", 0x2A89);
		entity("lnapprox", 0x2A89);
		entity("lne", 0x2A87);
		entity("lnE", 0x2268);
		entity("lneq", 0x2A87);
		entity("lneqq", 0x2268);
		entity("lnsim", 0x22E6);
		entity("loang", 0x27EC);
		entity("loarr", 0x21FD);
		entity("lobrk", 0x27E6);
		entity("longleftarrow", 0x27F5);
		entity("Longleftarrow", 0x27F8);
		entity("LongLeftArrow", 0x27F5);
		entity("longleftrightarrow", 0x27F7);
		entity("Longleftrightarrow", 0x27FA);
		entity("LongLeftRightArrow", 0x27F7);
		entity("longmapsto", 0x27FC);
		entity("longrightarrow", 0x27F6);
		entity("Longrightarrow", 0x27F9);
		entity("LongRightArrow", 0x27F6);
		entity("looparrowleft", 0x21AB);
		entity("looparrowright", 0x21AC);
		entity("lopar", 0x2985);
		entity("lopf", 0x1D55D);
		entity("Lopf", 0x1D543);
		entity("loplus", 0x2A2D);
		entity("lotimes", 0x2A34);
		entity("lowast", 0x2217);
		entity("lowbar", 0x005F);
		entity("LowerLeftArrow", 0x2199);
		entity("LowerRightArrow", 0x2198);
		entity("loz", 0x25CA);
		entity("lozenge", 0x25CA);
		entity("lozf", 0x29EB);
		entity("lpar", 0x0028);
		entity("lparlt", 0x2993);
		entity("lrarr", 0x21C6);
		entity("lrcorner", 0x231F);
		entity("lrhar", 0x21CB);
		entity("lrhard", 0x296D);
		entity("lrm", 0x200E);
		entity("lrtri", 0x22BF);
		entity("lsaquo", 0x2039);
		entity("lscr", 0x1D4C1);
		entity("Lscr", 0x2112);
		entity("lsh", 0x21B0);
		entity("Lsh", 0x21B0);
		entity("lsim", 0x2272);
		entity("lsime", 0x2A8D);
		entity("lsimg", 0x2A8F);
		entity("lsqb", 0x005B);
		entity("lsquo", 0x2018);
		entity("lsquor", 0x201A);
		entity("lstrok", 0x0142);
		entity("Lstrok", 0x0141);
		entity("lt", 0x003C);
		entity("Lt", 0x226A);
		entity("LT", 0x003C);
		entity("ltcc", 0x2AA6);
		entity("ltcir", 0x2A79);
		entity("ltdot", 0x22D6);
		entity("lthree", 0x22CB);
		entity("ltimes", 0x22C9);
		entity("ltlarr", 0x2976);
		entity("ltquest", 0x2A7B);
		entity("ltri", 0x25C3);
		entity("ltrie", 0x22B4);
		entity("ltrif", 0x25C2);
		entity("ltrPar", 0x2996);
		entity("lurdshar", 0x294A);
		entity("luruhar", 0x2966);
		entity("macr", 0x00AF);
		entity("male", 0x2642);
		entity("malt", 0x2720);
		entity("maltese", 0x2720);
		entity("map", 0x21A6);
		entity("Map", 0x2905);
		entity("mapsto", 0x21A6);
		entity("mapstodown", 0x21A7);
		entity("mapstoleft", 0x21A4);
		entity("mapstoup", 0x21A5);
		entity("marker", 0x25AE);
		entity("mcomma", 0x2A29);
		entity("mcy", 0x043C);
		entity("Mcy", 0x041C);
		entity("mdash", 0x2014);
		entity("mDDot", 0x223A);
		entity("measuredangle", 0x2221);
		entity("MediumSpace", 0x205F);
		entity("Mellintrf", 0x2133);
		entity("mfr", 0x1D52A);
		entity("Mfr", 0x1D510);
		entity("mgr", 0x03BC);
		entity("Mgr", 0x039C);
		entity("mho", 0x2127);
		entity("micro", 0x00B5);
		entity("mid", 0x2223);
		entity("midast", 0x002A);
		entity("midcir", 0x2AF0);
		entity("middot", 0x00B7);
		entity("minus", 0x2212);
		entity("minusb", 0x229F);
		entity("minusd", 0x2238);
		entity("minusdu", 0x2A2A);
		entity("MinusPlus", 0x2213);
		entity("mlcp", 0x2ADB);
		entity("mldr", 0x2026);
		entity("mnplus", 0x2213);
		entity("models", 0x22A7);
		entity("mopf", 0x1D55E);
		entity("Mopf", 0x1D544);
		entity("mp", 0x2213);
		entity("mscr", 0x1D4C2);
		entity("Mscr", 0x2133);
		entity("mstpos", 0x223E);
		entity("mu", 0x03BC);
		entity("Mu", 0x039C);
		entity("multimap", 0x22B8);
		entity("mumap", 0x22B8);
		entity("nabla", 0x2207);
		entity("nacute", 0x0144);
		entity("Nacute", 0x0143);
		entity("nap", 0x2249);
		entity("napos", 0x0149);
		entity("napprox", 0x2249);
		entity("natur", 0x266E);
		entity("natural", 0x266E);
		entity("naturals", 0x2115);
		entity("nbsp", 0x00A0);
		entity("ncap", 0x2A43);
		entity("ncaron", 0x0148);
		entity("Ncaron", 0x0147);
		entity("ncedil", 0x0146);
		entity("Ncedil", 0x0145);
		entity("ncong", 0x2247);
		entity("ncup", 0x2A42);
		entity("ncy", 0x043D);
		entity("Ncy", 0x041D);
		entity("ndash", 0x2013);
		entity("ne", 0x2260);
		entity("nearhk", 0x2924);
		entity("nearr", 0x2197);
		entity("neArr", 0x21D7);
		entity("nearrow", 0x2197);
		entity("NegativeMediumSpace", 0x200B);
		entity("NegativeThickSpace", 0x200B);
		entity("NegativeThinSpace", 0x200B);
		entity("NegativeVeryThinSpace", 0x200B);
		entity("nequiv", 0x2262);
		entity("nesear", 0x2928);
		entity("NestedGreaterGreater", 0x226B);
		entity("NestedLessLess", 0x226A);
		entity("NewLine", 0x000A);
		entity("nexist", 0x2204);
		entity("nexists", 0x2204);
		entity("nfr", 0x1D52B);
		entity("Nfr", 0x1D511);
		entity("nge", 0x2271);
		entity("ngeq", 0x2271);
		entity("ngr", 0x03BD);
		entity("Ngr", 0x039D);
		entity("ngsim", 0x2275);
		entity("ngt", 0x226F);
		entity("ngtr", 0x226F);
		entity("nharr", 0x21AE);
		entity("nhArr", 0x21CE);
		entity("nhpar", 0x2AF2);
		entity("ni", 0x220B);
		entity("nis", 0x22FC);
		entity("nisd", 0x22FA);
		entity("niv", 0x220B);
		entity("njcy", 0x045A);
		entity("NJcy", 0x040A);
		entity("nlarr", 0x219A);
		entity("nlArr", 0x21CD);
		entity("nldr", 0x2025);
		entity("nle", 0x2270);
		entity("nleftarrow", 0x219A);
		entity("nLeftarrow", 0x21CD);
		entity("nleftrightarrow", 0x21AE);
		entity("nLeftrightarrow", 0x21CE);
		entity("nleq", 0x2270);
		entity("nless", 0x226E);
		entity("nlsim", 0x2274);
		entity("nlt", 0x226E);
		entity("nltri", 0x22EA);
		entity("nltrie", 0x22EC);
		entity("nmid", 0x2224);
		entity("NoBreak", 0x2060);
		entity("NonBreakingSpace", 0x00A0);
		entity("nopf", 0x1D55F);
		entity("Nopf", 0x2115);
		entity("not", 0x00AC);
		entity("Not", 0x2AEC);
		entity("NotCongruent", 0x2262);
		entity("NotCupCap", 0x226D);
		entity("NotDoubleVerticalBar", 0x2226);
		entity("NotElement", 0x2209);
		entity("NotEqual", 0x2260);
		entity("NotExists", 0x2204);
		entity("NotGreater", 0x226F);
		entity("NotGreaterEqual", 0x2271);
		entity("NotGreaterLess", 0x2279);
		entity("NotGreaterTilde", 0x2275);
		entity("notin", 0x2209);
		entity("notinva", 0x2209);
		entity("notinvb", 0x22F7);
		entity("notinvc", 0x22F6);
		entity("NotLeftTriangle", 0x22EA);
		entity("NotLeftTriangleEqual", 0x22EC);
		entity("NotLess", 0x226E);
		entity("NotLessEqual", 0x2270);
		entity("NotLessGreater", 0x2278);
		entity("NotLessTilde", 0x2274);
		entity("notni", 0x220C);
		entity("notniva", 0x220C);
		entity("notnivb", 0x22FE);
		entity("notnivc", 0x22FD);
		entity("NotPrecedes", 0x2280);
		entity("NotPrecedesSlantEqual", 0x22E0);
		entity("NotReverseElement", 0x220C);
		entity("NotRightTriangle", 0x22EB);
		entity("NotRightTriangleEqual", 0x22ED);
		entity("NotSquareSubsetEqual", 0x22E2);
		entity("NotSquareSupersetEqual", 0x22E3);
		entity("NotSubsetEqual", 0x2288);
		entity("NotSucceeds", 0x2281);
		entity("NotSucceedsSlantEqual", 0x22E1);
		entity("NotSupersetEqual", 0x2289);
		entity("NotTilde", 0x2241);
		entity("NotTildeEqual", 0x2244);
		entity("NotTildeFullEqual", 0x2247);
		entity("NotTildeTilde", 0x2249);
		entity("NotVerticalBar", 0x2224);
		entity("npar", 0x2226);
		entity("nparallel", 0x2226);
		entity("npolint", 0x2A14);
		entity("npr", 0x2280);
		entity("nprcue", 0x22E0);
		entity("nprec", 0x2280);
		entity("nrarr", 0x219B);
		entity("nrArr", 0x21CF);
		entity("nrightarrow", 0x219B);
		entity("nRightarrow", 0x21CF);
		entity("nrtri", 0x22EB);
		entity("nrtrie", 0x22ED);
		entity("nsc", 0x2281);
		entity("nsccue", 0x22E1);
		entity("nscr", 0x1D4C3);
		entity("Nscr", 0x1D4A9);
		entity("nshortmid", 0x2224);
		entity("nshortparallel", 0x2226);
		entity("nsim", 0x2241);
		entity("nsime", 0x2244);
		entity("nsimeq", 0x2244);
		entity("nsmid", 0x2224);
		entity("nspar", 0x2226);
		entity("nsqsube", 0x22E2);
		entity("nsqsupe", 0x22E3);
		entity("nsub", 0x2284);
		entity("nsube", 0x2288);
		entity("nsubseteq", 0x2288);
		entity("nsucc", 0x2281);
		entity("nsup", 0x2285);
		entity("nsupe", 0x2289);
		entity("nsupseteq", 0x2289);
		entity("ntgl", 0x2279);
		entity("ntilde", 0x00F1);
		entity("Ntilde", 0x00D1);
		entity("ntlg", 0x2278);
		entity("ntriangleleft", 0x22EA);
		entity("ntrianglelefteq", 0x22EC);
		entity("ntriangleright", 0x22EB);
		entity("ntrianglerighteq", 0x22ED);
		entity("nu", 0x03BD);
		entity("Nu", 0x039D);
		entity("num", 0x0023);
		entity("numero", 0x2116);
		entity("numsp", 0x2007);
		entity("nvdash", 0x22AC);
		entity("nvDash", 0x22AD);
		entity("nVdash", 0x22AE);
		entity("nVDash", 0x22AF);
		entity("nvHarr", 0x2904);
		entity("nvinfin", 0x29DE);
		entity("nvlArr", 0x2902);
		entity("nvrArr", 0x2903);
		entity("nwarhk", 0x2923);
		entity("nwarr", 0x2196);
		entity("nwArr", 0x21D6);
		entity("nwarrow", 0x2196);
		entity("nwnear", 0x2927);
		entity("oacgr", 0x03CC);
		entity("Oacgr", 0x038C);
		entity("oacute", 0x00F3);
		entity("Oacute", 0x00D3);
		entity("oast", 0x229B);
		entity("ocir", 0x229A);
		entity("ocirc", 0x00F4);
		entity("Ocirc", 0x00D4);
		entity("ocy", 0x043E);
		entity("Ocy", 0x041E);
		entity("odash", 0x229D);
		entity("odblac", 0x0151);
		entity("Odblac", 0x0150);
		entity("odiv", 0x2A38);
		entity("odot", 0x2299);
		entity("odsold", 0x29BC);
		entity("oelig", 0x0153);
		entity("OElig", 0x0152);
		entity("ofcir", 0x29BF);
		entity("ofr", 0x1D52C);
		entity("Ofr", 0x1D512);
		entity("ogon", 0x02DB);
		entity("ogr", 0x03BF);
		entity("Ogr", 0x039F);
		entity("ograve", 0x00F2);
		entity("Ograve", 0x00D2);
		entity("ogt", 0x29C1);
		entity("ohacgr", 0x03CE);
		entity("OHacgr", 0x038F);
		entity("ohbar", 0x29B5);
		entity("ohgr", 0x03C9);
		entity("OHgr", 0x03A9);
		entity("ohm", 0x03A9);
		entity("oint", 0x222E);
		entity("olarr", 0x21BA);
		entity("olcir", 0x29BE);
		entity("olcross", 0x29BB);
		entity("oline", 0x203E);
		entity("olt", 0x29C0);
		entity("omacr", 0x014D);
		entity("Omacr", 0x014C);
		entity("omega", 0x03C9);
		entity("Omega", 0x03A9);
		entity("omicron", 0x03BF);
		entity("Omicron", 0x039F);
		entity("omid", 0x29B6);
		entity("ominus", 0x2296);
		entity("oopf", 0x1D560);
		entity("Oopf", 0x1D546);
		entity("opar", 0x29B7);
		entity("OpenCurlyDoubleQuote", 0x201C);
		entity("OpenCurlyQuote", 0x2018);
		entity("operp", 0x29B9);
		entity("oplus", 0x2295);
		entity("or", 0x2228);
		entity("Or", 0x2A54);
		entity("orarr", 0x21BB);
		entity("ord", 0x2A5D);
		entity("order", 0x2134);
		entity("orderof", 0x2134);
		entity("ordf", 0x00AA);
		entity("ordm", 0x00BA);
		entity("origof", 0x22B6);
		entity("oror", 0x2A56);
		entity("orslope", 0x2A57);
		entity("orv", 0x2A5B);
		entity("oS", 0x24C8);
		entity("oscr", 0x2134);
		entity("Oscr", 0x1D4AA);
		entity("oslash", 0x00F8);
		entity("Oslash", 0x00D8);
		entity("osol", 0x2298);
		entity("otilde", 0x00F5);
		entity("Otilde", 0x00D5);
		entity("otimes", 0x2297);
		entity("Otimes", 0x2A37);
		entity("otimesas", 0x2A36);
		entity("ouml", 0x00F6);
		entity("Ouml", 0x00D6);
		entity("ovbar", 0x233D);
		entity("OverBar", 0x203E);
		entity("OverBrace", 0x23DE);
		entity("OverBracket", 0x23B4);
		entity("OverParenthesis", 0x23DC);
		entity("par", 0x2225);
		entity("para", 0x00B6);
		entity("parallel", 0x2225);
		entity("parsim", 0x2AF3);
		entity("parsl", 0x2AFD);
		entity("part", 0x2202);
		entity("PartialD", 0x2202);
		entity("pcy", 0x043F);
		entity("Pcy", 0x041F);
		entity("percnt", 0x0025);
		entity("period", 0x002E);
		entity("permil", 0x2030);
		entity("perp", 0x22A5);
		entity("pertenk", 0x2031);
		entity("pfr", 0x1D52D);
		entity("Pfr", 0x1D513);
		entity("pgr", 0x03C0);
		entity("Pgr", 0x03A0);
		entity("phgr", 0x03C6);
		entity("PHgr", 0x03A6);
		entity("phi", 0x03C6);
		entity("Phi", 0x03A6);
		entity("phiv", 0x03D5);
		entity("phmmat", 0x2133);
		entity("phone", 0x260E);
		entity("pi", 0x03C0);
		entity("Pi", 0x03A0);
		entity("pitchfork", 0x22D4);
		entity("piv", 0x03D6);
		entity("planck", 0x210F);
		entity("planckh", 0x210E);
		entity("plankv", 0x210F);
		entity("plus", 0x002B);
		entity("plusacir", 0x2A23);
		entity("plusb", 0x229E);
		entity("pluscir", 0x2A22);
		entity("plusdo", 0x2214);
		entity("plusdu", 0x2A25);
		entity("pluse", 0x2A72);
		entity("PlusMinus", 0x00B1);
		entity("plusmn", 0x00B1);
		entity("plussim", 0x2A26);
		entity("plustwo", 0x2A27);
		entity("pm", 0x00B1);
		entity("Poincareplane", 0x210C);
		entity("pointint", 0x2A15);
		entity("popf", 0x1D561);
		entity("Popf", 0x2119);
		entity("pound", 0x00A3);
		entity("pr", 0x227A);
		entity("Pr", 0x2ABB);
		entity("prap", 0x2AB7);
		entity("prcue", 0x227C);
		entity("pre", 0x2AAF);
		entity("prE", 0x2AB3);
		entity("prec", 0x227A);
		entity("precapprox", 0x2AB7);
		entity("preccurlyeq", 0x227C);
		entity("Precedes", 0x227A);
		entity("PrecedesEqual", 0x2AAF);
		entity("PrecedesSlantEqual", 0x227C);
		entity("PrecedesTilde", 0x227E);
		entity("preceq", 0x2AAF);
		entity("precnapprox", 0x2AB9);
		entity("precneqq", 0x2AB5);
		entity("precnsim", 0x22E8);
		entity("precsim", 0x227E);
		entity("prime", 0x2032);
		entity("Prime", 0x2033);
		entity("primes", 0x2119);
		entity("prnap", 0x2AB9);
		entity("prnE", 0x2AB5);
		entity("prnsim", 0x22E8);
		entity("prod", 0x220F);
		entity("Product", 0x220F);
		entity("profalar", 0x232E);
		entity("profline", 0x2312);
		entity("profsurf", 0x2313);
		entity("prop", 0x221D);
		entity("Proportion", 0x2237);
		entity("Proportional", 0x221D);
		entity("propto", 0x221D);
		entity("prsim", 0x227E);
		entity("prurel", 0x22B0);
		entity("pscr", 0x1D4C5);
		entity("Pscr", 0x1D4AB);
		entity("psgr", 0x03C8);
		entity("PSgr", 0x03A8);
		entity("psi", 0x03C8);
		entity("Psi", 0x03A8);
		entity("puncsp", 0x2008);
		entity("qfr", 0x1D52E);
		entity("Qfr", 0x1D514);
		entity("qint", 0x2A0C);
		entity("qopf", 0x1D562);
		entity("Qopf", 0x211A);
		entity("qprime", 0x2057);
		entity("qscr", 0x1D4C6);
		entity("Qscr", 0x1D4AC);
		entity("quaternions", 0x210D);
		entity("quatint", 0x2A16);
		entity("quest", 0x003F);
		entity("questeq", 0x225F);
		entity("quot", 0x0022);
		entity("QUOT", 0x0022);
		entity("rAarr", 0x21DB);
		entity("racute", 0x0155);
		entity("Racute", 0x0154);
		entity("radic", 0x221A);
		entity("raemptyv", 0x29B3);
		entity("rang", 0x27E9);
		entity("Rang", 0x27EB);
		entity("rangd", 0x2992);
		entity("range", 0x29A5);
		entity("rangle", 0x27E9);
		entity("raquo", 0x00BB);
		entity("rarr", 0x2192);
		entity("rArr", 0x21D2);
		entity("Rarr", 0x21A0);
		entity("rarrap", 0x2975);
		entity("rarrb", 0x21E5);
		entity("rarrbfs", 0x2920);
		entity("rarrc", 0x2933);
		entity("rarrfs", 0x291E);
		entity("rarrhk", 0x21AA);
		entity("rarrlp", 0x21AC);
		entity("rarrpl", 0x2945);
		entity("rarrsim", 0x2974);
		entity("rarrtl", 0x21A3);
		entity("Rarrtl", 0x2916);
		entity("rarrw", 0x219D);
		entity("ratail", 0x291A);
		entity("rAtail", 0x291C);
		entity("ratio", 0x2236);
		entity("rationals", 0x211A);
		entity("rbarr", 0x290D);
		entity("rBarr", 0x290F);
		entity("RBarr", 0x2910);
		entity("rbbrk", 0x2773);
		entity("rbrace", 0x007D);
		entity("rbrack", 0x005D);
		entity("rbrke", 0x298C);
		entity("rbrksld", 0x298E);
		entity("rbrkslu", 0x2990);
		entity("rcaron", 0x0159);
		entity("Rcaron", 0x0158);
		entity("rcedil", 0x0157);
		entity("Rcedil", 0x0156);
		entity("rceil", 0x2309);
		entity("rcub", 0x007D);
		entity("rcy", 0x0440);
		entity("Rcy", 0x0420);
		entity("rdca", 0x2937);
		entity("rdldhar", 0x2969);
		entity("rdquo", 0x201D);
		entity("rdquor", 0x201D);
		entity("rdsh", 0x21B3);
		entity("Re", 0x211C);
		entity("real", 0x211C);
		entity("realine", 0x211B);
		entity("realpart", 0x211C);
		entity("reals", 0x211D);
		entity("rect", 0x25AD);
		entity("reg", 0x00AE);
		entity("REG", 0x00AE);
		entity("ReverseElement", 0x220B);
		entity("ReverseEquilibrium", 0x21CB);
		entity("ReverseUpEquilibrium", 0x296F);
		entity("rfisht", 0x297D);
		entity("rfloor", 0x230B);
		entity("rfr", 0x1D52F);
		entity("Rfr", 0x211C);
		entity("rgr", 0x03C1);
		entity("Rgr", 0x03A1);
		entity("rHar", 0x2964);
		entity("rhard", 0x21C1);
		entity("rharu", 0x21C0);
		entity("rharul", 0x296C);
		entity("rho", 0x03C1);
		entity("Rho", 0x03A1);
		entity("rhov", 0x03F1);
		entity("RightAngleBracket", 0x27E9);
		entity("rightarrow", 0x2192);
		entity("Rightarrow", 0x21D2);
		entity("RightArrow", 0x2192);
		entity("RightArrowBar", 0x21E5);
		entity("RightArrowLeftArrow", 0x21C4);
		entity("rightarrowtail", 0x21A3);
		entity("RightCeiling", 0x2309);
		entity("RightDoubleBracket", 0x27E7);
		entity("RightDownTeeVector", 0x295D);
		entity("RightDownVector", 0x21C2);
		entity("RightDownVectorBar", 0x2955);
		entity("RightFloor", 0x230B);
		entity("rightharpoondown", 0x21C1);
		entity("rightharpoonup", 0x21C0);
		entity("rightleftarrows", 0x21C4);
		entity("rightleftharpoons", 0x21CC);
		entity("rightrightarrows", 0x21C9);
		entity("rightsquigarrow", 0x219D);
		entity("RightTee", 0x22A2);
		entity("RightTeeArrow", 0x21A6);
		entity("RightTeeVector", 0x295B);
		entity("rightthreetimes", 0x22CC);
		entity("RightTriangle", 0x22B3);
		entity("RightTriangleBar", 0x29D0);
		entity("RightTriangleEqual", 0x22B5);
		entity("RightUpDownVector", 0x294F);
		entity("RightUpTeeVector", 0x295C);
		entity("RightUpVector", 0x21BE);
		entity("RightUpVectorBar", 0x2954);
		entity("RightVector", 0x21C0);
		entity("RightVectorBar", 0x2953);
		entity("ring", 0x02DA);
		entity("risingdotseq", 0x2253);
		entity("rlarr", 0x21C4);
		entity("rlhar", 0x21CC);
		entity("rlm", 0x200F);
		entity("rmoust", 0x23B1);
		entity("rmoustache", 0x23B1);
		entity("rnmid", 0x2AEE);
		entity("roang", 0x27ED);
		entity("roarr", 0x21FE);
		entity("robrk", 0x27E7);
		entity("ropar", 0x2986);
		entity("ropf", 0x1D563);
		entity("Ropf", 0x211D);
		entity("roplus", 0x2A2E);
		entity("rotimes", 0x2A35);
		entity("RoundImplies", 0x2970);
		entity("rpar", 0x0029);
		entity("rpargt", 0x2994);
		entity("rppolint", 0x2A12);
		entity("rrarr", 0x21C9);
		entity("Rrightarrow", 0x21DB);
		entity("rsaquo", 0x203A);
		entity("rscr", 0x1D4C7);
		entity("Rscr", 0x211B);
		entity("rsh", 0x21B1);
		entity("Rsh", 0x21B1);
		entity("rsqb", 0x005D);
		entity("rsquo", 0x2019);
		entity("rsquor", 0x2019);
		entity("rthree", 0x22CC);
		entity("rtimes", 0x22CA);
		entity("rtri", 0x25B9);
		entity("rtrie", 0x22B5);
		entity("rtrif", 0x25B8);
		entity("rtriltri", 0x29CE);
		entity("RuleDelayed", 0x29F4);
		entity("ruluhar", 0x2968);
		entity("rx", 0x211E);
		entity("sacute", 0x015B);
		entity("Sacute", 0x015A);
		entity("sbquo", 0x201A);
		entity("sc", 0x227B);
		entity("Sc", 0x2ABC);
		entity("scap", 0x2AB8);
		entity("scaron", 0x0161);
		entity("Scaron", 0x0160);
		entity("sccue", 0x227D);
		entity("sce", 0x2AB0);
		entity("scE", 0x2AB4);
		entity("scedil", 0x015F);
		entity("Scedil", 0x015E);
		entity("scirc", 0x015D);
		entity("Scirc", 0x015C);
		entity("scnap", 0x2ABA);
		entity("scnE", 0x2AB6);
		entity("scnsim", 0x22E9);
		entity("scpolint", 0x2A13);
		entity("scsim", 0x227F);
		entity("scy", 0x0441);
		entity("Scy", 0x0421);
		entity("sdot", 0x22C5);
		entity("sdotb", 0x22A1);
		entity("sdote", 0x2A66);
		entity("searhk", 0x2925);
		entity("searr", 0x2198);
		entity("seArr", 0x21D8);
		entity("searrow", 0x2198);
		entity("sect", 0x00A7);
		entity("semi", 0x003B);
		entity("seswar", 0x2929);
		entity("setminus", 0x2216);
		entity("setmn", 0x2216);
		entity("sext", 0x2736);
		entity("sfgr", 0x03C2);
		entity("sfr", 0x1D530);
		entity("Sfr", 0x1D516);
		entity("sfrown", 0x2322);
		entity("sgr", 0x03C3);
		entity("Sgr", 0x03A3);
		entity("sharp", 0x266F);
		entity("shchcy", 0x0449);
		entity("SHCHcy", 0x0429);
		entity("shcy", 0x0448);
		entity("SHcy", 0x0428);
		entity("ShortDownArrow", 0x2193);
		entity("ShortLeftArrow", 0x2190);
		entity("shortmid", 0x2223);
		entity("shortparallel", 0x2225);
		entity("ShortRightArrow", 0x2192);
		entity("ShortUpArrow", 0x2191);
		entity("shy", 0x00AD);
		entity("sigma", 0x03C3);
		entity("Sigma", 0x03A3);
		entity("sigmaf", 0x03C2);
		entity("sigmav", 0x03C2);
		entity("sim", 0x223C);
		entity("simdot", 0x2A6A);
		entity("sime", 0x2243);
		entity("simeq", 0x2243);
		entity("simg", 0x2A9E);
		entity("simgE", 0x2AA0);
		entity("siml", 0x2A9D);
		entity("simlE", 0x2A9F);
		entity("simne", 0x2246);
		entity("simplus", 0x2A24);
		entity("simrarr", 0x2972);
		entity("slarr", 0x2190);
		entity("SmallCircle", 0x2218);
		entity("smallsetminus", 0x2216);
		entity("smashp", 0x2A33);
		entity("smeparsl", 0x29E4);
		entity("smid", 0x2223);
		entity("smile", 0x2323);
		entity("smt", 0x2AAA);
		entity("smte", 0x2AAC);
		entity("softcy", 0x044C);
		entity("SOFTcy", 0x042C);
		entity("sol", 0x002F);
		entity("solb", 0x29C4);
		entity("solbar", 0x233F);
		entity("sopf", 0x1D564);
		entity("Sopf", 0x1D54A);
		entity("spades", 0x2660);
		entity("spadesuit", 0x2660);
		entity("spar", 0x2225);
		entity("sqcap", 0x2293);
		entity("sqcup", 0x2294);
		entity("Sqrt", 0x221A);
		entity("sqsub", 0x228F);
		entity("sqsube", 0x2291);
		entity("sqsubset", 0x228F);
		entity("sqsubseteq", 0x2291);
		entity("sqsup", 0x2290);
		entity("sqsupe", 0x2292);
		entity("sqsupset", 0x2290);
		entity("sqsupseteq", 0x2292);
		entity("squ", 0x25A1);
		entity("square", 0x25A1);
		entity("Square", 0x25A1);
		entity("SquareIntersection", 0x2293);
		entity("SquareSubset", 0x228F);
		entity("SquareSubsetEqual", 0x2291);
		entity("SquareSuperset", 0x2290);
		entity("SquareSupersetEqual", 0x2292);
		entity("SquareUnion", 0x2294);
		entity("squarf", 0x25AA);
		entity("squf", 0x25AA);
		entity("srarr", 0x2192);
		entity("sscr", 0x1D4C8);
		entity("Sscr", 0x1D4AE);
		entity("ssetmn", 0x2216);
		entity("ssmile", 0x2323);
		entity("sstarf", 0x22C6);
		entity("star", 0x2606);
		entity("Star", 0x22C6);
		entity("starf", 0x2605);
		entity("straightepsilon", 0x03F5);
		entity("straightphi", 0x03D5);
		entity("strns", 0x00AF);
		entity("sub", 0x2282);
		entity("Sub", 0x22D0);
		entity("subdot", 0x2ABD);
		entity("sube", 0x2286);
		entity("subE", 0x2AC5);
		entity("subedot", 0x2AC3);
		entity("submult", 0x2AC1);
		entity("subne", 0x228A);
		entity("subnE", 0x2ACB);
		entity("subplus", 0x2ABF);
		entity("subrarr", 0x2979);
		entity("subset", 0x2282);
		entity("Subset", 0x22D0);
		entity("subseteq", 0x2286);
		entity("subseteqq", 0x2AC5);
		entity("SubsetEqual", 0x2286);
		entity("subsetneq", 0x228A);
		entity("subsetneqq", 0x2ACB);
		entity("subsim", 0x2AC7);
		entity("subsub", 0x2AD5);
		entity("subsup", 0x2AD3);
		entity("succ", 0x227B);
		entity("succapprox", 0x2AB8);
		entity("succcurlyeq", 0x227D);
		entity("Succeeds", 0x227B);
		entity("SucceedsEqual", 0x2AB0);
		entity("SucceedsSlantEqual", 0x227D);
		entity("SucceedsTilde", 0x227F);
		entity("succeq", 0x2AB0);
		entity("succnapprox", 0x2ABA);
		entity("succneqq", 0x2AB6);
		entity("succnsim", 0x22E9);
		entity("succsim", 0x227F);
		entity("SuchThat", 0x220B);
		entity("sum", 0x2211);
		entity("Sum", 0x2211);
		entity("sung", 0x266A);
		entity("sup", 0x2283);
		entity("Sup", 0x22D1);
		entity("sup1", 0x00B9);
		entity("sup2", 0x00B2);
		entity("sup3", 0x00B3);
		entity("supdot", 0x2ABE);
		entity("supdsub", 0x2AD8);
		entity("supe", 0x2287);
		entity("supE", 0x2AC6);
		entity("supedot", 0x2AC4);
		entity("Superset", 0x2283);
		entity("SupersetEqual", 0x2287);
		entity("suphsol", 0x27C9);
		entity("suphsub", 0x2AD7);
		entity("suplarr", 0x297B);
		entity("supmult", 0x2AC2);
		entity("supne", 0x228B);
		entity("supnE", 0x2ACC);
		entity("supplus", 0x2AC0);
		entity("supset", 0x2283);
		entity("Supset", 0x22D1);
		entity("supseteq", 0x2287);
		entity("supseteqq", 0x2AC6);
		entity("supsetneq", 0x228B);
		entity("supsetneqq", 0x2ACC);
		entity("supsim", 0x2AC8);
		entity("supsub", 0x2AD4);
		entity("supsup", 0x2AD6);
		entity("swarhk", 0x2926);
		entity("swarr", 0x2199);
		entity("swArr", 0x21D9);
		entity("swarrow", 0x2199);
		entity("swnwar", 0x292A);
		entity("szlig", 0x00DF);
		entity("Tab", 0x0009);
		entity("target", 0x2316);
		entity("tau", 0x03C4);
		entity("Tau", 0x03A4);
		entity("tbrk", 0x23B4);
		entity("tcaron", 0x0165);
		entity("Tcaron", 0x0164);
		entity("tcedil", 0x0163);
		entity("Tcedil", 0x0162);
		entity("tcy", 0x0442);
		entity("Tcy", 0x0422);
		entity("telrec", 0x2315);
		entity("tfr", 0x1D531);
		entity("Tfr", 0x1D517);
		entity("tgr", 0x03C4);
		entity("Tgr", 0x03A4);
		entity("there4", 0x2234);
		entity("therefore", 0x2234);
		entity("Therefore", 0x2234);
		entity("theta", 0x03B8);
		entity("Theta", 0x0398);
		entity("thetasym", 0x03D1);
		entity("thetav", 0x03D1);
		entity("thgr", 0x03B8);
		entity("THgr", 0x0398);
		entity("thickapprox", 0x2248);
		entity("thicksim", 0x223C);
		entity("thinsp", 0x2009);
		entity("ThinSpace", 0x2009);
		entity("thkap", 0x2248);
		entity("thksim", 0x223C);
		entity("thorn", 0x00FE);
		entity("THORN", 0x00DE);
		entity("tilde", 0x02DC);
		entity("Tilde", 0x223C);
		entity("TildeEqual", 0x2243);
		entity("TildeFullEqual", 0x2245);
		entity("TildeTilde", 0x2248);
		entity("times", 0x00D7);
		entity("timesb", 0x22A0);
		entity("timesbar", 0x2A31);
		entity("timesd", 0x2A30);
		entity("tint", 0x222D);
		entity("toea", 0x2928);
		entity("top", 0x22A4);
		entity("topbot", 0x2336);
		entity("topcir", 0x2AF1);
		entity("topf", 0x1D565);
		entity("Topf", 0x1D54B);
		entity("topfork", 0x2ADA);
		entity("tosa", 0x2929);
		entity("tprime", 0x2034);
		entity("trade", 0x2122);
		entity("TRADE", 0x2122);
		entity("triangle", 0x25B5);
		entity("triangledown", 0x25BF);
		entity("triangleleft", 0x25C3);
		entity("trianglelefteq", 0x22B4);
		entity("triangleq", 0x225C);
		entity("triangleright", 0x25B9);
		entity("trianglerighteq", 0x22B5);
		entity("tridot", 0x25EC);
		entity("trie", 0x225C);
		entity("triminus", 0x2A3A);
		entity("triplus", 0x2A39);
		entity("trisb", 0x29CD);
		entity("tritime", 0x2A3B);
		entity("trpezium", 0x23E2);
		entity("tscr", 0x1D4C9);
		entity("Tscr", 0x1D4AF);
		entity("tscy", 0x0446);
		entity("TScy", 0x0426);
		entity("tshcy", 0x045B);
		entity("TSHcy", 0x040B);
		entity("tstrok", 0x0167);
		entity("Tstrok", 0x0166);
		entity("twixt", 0x226C);
		entity("twoheadleftarrow", 0x219E);
		entity("twoheadrightarrow", 0x21A0);
		entity("uacgr", 0x03CD);
		entity("Uacgr", 0x038E);
		entity("uacute", 0x00FA);
		entity("Uacute", 0x00DA);
		entity("uarr", 0x2191);
		entity("uArr", 0x21D1);
		entity("Uarr", 0x219F);
		entity("Uarrocir", 0x2949);
		entity("ubrcy", 0x045E);
		entity("Ubrcy", 0x040E);
		entity("ubreve", 0x016D);
		entity("Ubreve", 0x016C);
		entity("ucirc", 0x00FB);
		entity("Ucirc", 0x00DB);
		entity("ucy", 0x0443);
		entity("Ucy", 0x0423);
		entity("udarr", 0x21C5);
		entity("udblac", 0x0171);
		entity("Udblac", 0x0170);
		entity("udhar", 0x296E);
		entity("udiagr", 0x03B0);
		entity("udigr", 0x03CB);
		entity("Udigr", 0x03AB);
		entity("ufisht", 0x297E);
		entity("ufr", 0x1D532);
		entity("Ufr", 0x1D518);
		entity("ugr", 0x03C5);
		entity("Ugr", 0x03A5);
		entity("ugrave", 0x00F9);
		entity("Ugrave", 0x00D9);
		entity("uHar", 0x2963);
		entity("uharl", 0x21BF);
		entity("uharr", 0x21BE);
		entity("uhblk", 0x2580);
		entity("ulcorn", 0x231C);
		entity("ulcorner", 0x231C);
		entity("ulcrop", 0x230F);
		entity("ultri", 0x25F8);
		entity("umacr", 0x016B);
		entity("Umacr", 0x016A);
		entity("uml", 0x00A8);
		entity("UnderBar", 0x005F);
		entity("UnderBrace", 0x23DF);
		entity("UnderBracket", 0x23B5);
		entity("UnderParenthesis", 0x23DD);
		entity("Union", 0x22C3);
		entity("UnionPlus", 0x228E);
		entity("uogon", 0x0173);
		entity("Uogon", 0x0172);
		entity("uopf", 0x1D566);
		entity("Uopf", 0x1D54C);
		entity("uparrow", 0x2191);
		entity("Uparrow", 0x21D1);
		entity("UpArrow", 0x2191);
		entity("UpArrowBar", 0x2912);
		entity("UpArrowDownArrow", 0x21C5);
		entity("updownarrow", 0x2195);
		entity("Updownarrow", 0x21D5);
		entity("UpDownArrow", 0x2195);
		entity("UpEquilibrium", 0x296E);
		entity("upharpoonleft", 0x21BF);
		entity("upharpoonright", 0x21BE);
		entity("uplus", 0x228E);
		entity("UpperLeftArrow", 0x2196);
		entity("UpperRightArrow", 0x2197);
		entity("upsi", 0x03C5);
		entity("Upsi", 0x03D2);
		entity("upsih", 0x03D2);
		entity("upsilon", 0x03C5);
		entity("Upsilon", 0x03A5);
		entity("UpTee", 0x22A5);
		entity("UpTeeArrow", 0x21A5);
		entity("upuparrows", 0x21C8);
		entity("urcorn", 0x231D);
		entity("urcorner", 0x231D);
		entity("urcrop", 0x230E);
		entity("uring", 0x016F);
		entity("Uring", 0x016E);
		entity("urtri", 0x25F9);
		entity("uscr", 0x1D4CA);
		entity("Uscr", 0x1D4B0);
		entity("utdot", 0x22F0);
		entity("utilde", 0x0169);
		entity("Utilde", 0x0168);
		entity("utri", 0x25B5);
		entity("utrif", 0x25B4);
		entity("uuarr", 0x21C8);
		entity("uuml", 0x00FC);
		entity("Uuml", 0x00DC);
		entity("uwangle", 0x29A7);
		entity("vangrt", 0x299C);
		entity("varepsilon", 0x03F5);
		entity("varkappa", 0x03F0);
		entity("varnothing", 0x2205);
		entity("varphi", 0x03D5);
		entity("varpi", 0x03D6);
		entity("varpropto", 0x221D);
		entity("varr", 0x2195);
		entity("vArr", 0x21D5);
		entity("varrho", 0x03F1);
		entity("varsigma", 0x03C2);
		entity("vartheta", 0x03D1);
		entity("vartriangleleft", 0x22B2);
		entity("vartriangleright", 0x22B3);
		entity("vBar", 0x2AE8);
		entity("Vbar", 0x2AEB);
		entity("vBarv", 0x2AE9);
		entity("vcy", 0x0432);
		entity("Vcy", 0x0412);
		entity("vdash", 0x22A2);
		entity("vDash", 0x22A8);
		entity("Vdash", 0x22A9);
		entity("VDash", 0x22AB);
		entity("Vdashl", 0x2AE6);
		entity("vee", 0x2228);
		entity("Vee", 0x22C1);
		entity("veebar", 0x22BB);
		entity("veeeq", 0x225A);
		entity("vellip", 0x22EE);
		entity("verbar", 0x007C);
		entity("Verbar", 0x2016);
		entity("vert", 0x007C);
		entity("Vert", 0x2016);
		entity("VerticalBar", 0x2223);
		entity("VerticalLine", 0x007C);
		entity("VerticalSeparator", 0x2758);
		entity("VerticalTilde", 0x2240);
		entity("VeryThinSpace", 0x200A);
		entity("vfr", 0x1D533);
		entity("Vfr", 0x1D519);
		entity("vltri", 0x22B2);
		entity("vopf", 0x1D567);
		entity("Vopf", 0x1D54D);
		entity("vprop", 0x221D);
		entity("vrtri", 0x22B3);
		entity("vscr", 0x1D4CB);
		entity("Vscr", 0x1D4B1);
		entity("Vvdash", 0x22AA);
		entity("vzigzag", 0x299A);
		entity("wcirc", 0x0175);
		entity("Wcirc", 0x0174);
		entity("wedbar", 0x2A5F);
		entity("wedge", 0x2227);
		entity("Wedge", 0x22C0);
		entity("wedgeq", 0x2259);
		entity("weierp", 0x2118);
		entity("wfr", 0x1D534);
		entity("Wfr", 0x1D51A);
		entity("wopf", 0x1D568);
		entity("Wopf", 0x1D54E);
		entity("wp", 0x2118);
		entity("wr", 0x2240);
		entity("wreath", 0x2240);
		entity("wscr", 0x1D4CC);
		entity("Wscr", 0x1D4B2);
		entity("xcap", 0x22C2);
		entity("xcirc", 0x25EF);
		entity("xcup", 0x22C3);
		entity("xdtri", 0x25BD);
		entity("xfr", 0x1D535);
		entity("Xfr", 0x1D51B);
		entity("xgr", 0x03BE);
		entity("Xgr", 0x039E);
		entity("xharr", 0x27F7);
		entity("xhArr", 0x27FA);
		entity("xi", 0x03BE);
		entity("Xi", 0x039E);
		entity("xlarr", 0x27F5);
		entity("xlArr", 0x27F8);
		entity("xmap", 0x27FC);
		entity("xnis", 0x22FB);
		entity("xodot", 0x2A00);
		entity("xopf", 0x1D569);
		entity("Xopf", 0x1D54F);
		entity("xoplus", 0x2A01);
		entity("xotime", 0x2A02);
		entity("xrarr", 0x27F6);
		entity("xrArr", 0x27F9);
		entity("xscr", 0x1D4CD);
		entity("Xscr", 0x1D4B3);
		entity("xsqcup", 0x2A06);
		entity("xuplus", 0x2A04);
		entity("xutri", 0x25B3);
		entity("xvee", 0x22C1);
		entity("xwedge", 0x22C0);
		entity("yacute", 0x00FD);
		entity("Yacute", 0x00DD);
		entity("yacy", 0x044F);
		entity("YAcy", 0x042F);
		entity("ycirc", 0x0177);
		entity("Ycirc", 0x0176);
		entity("ycy", 0x044B);
		entity("Ycy", 0x042B);
		entity("yen", 0x00A5);
		entity("yfr", 0x1D536);
		entity("Yfr", 0x1D51C);
		entity("yicy", 0x0457);
		entity("YIcy", 0x0407);
		entity("yopf", 0x1D56A);
		entity("Yopf", 0x1D550);
		entity("yscr", 0x1D4CE);
		entity("Yscr", 0x1D4B4);
		entity("yucy", 0x044E);
		entity("YUcy", 0x042E);
		entity("yuml", 0x00FF);
		entity("Yuml", 0x0178);
		entity("zacute", 0x017A);
		entity("Zacute", 0x0179);
		entity("zcaron", 0x017E);
		entity("Zcaron", 0x017D);
		entity("zcy", 0x0437);
		entity("Zcy", 0x0417);
		entity("zdot", 0x017C);
		entity("Zdot", 0x017B);
		entity("zeetrf", 0x2128);
		entity("ZeroWidthSpace", 0x200B);
		entity("zeta", 0x03B6);
		entity("Zeta", 0x0396);
		entity("zfr", 0x1D537);
		entity("Zfr", 0x2128);
		entity("zgr", 0x03B6);
		entity("Zgr", 0x0396);
		entity("zhcy", 0x0436);
		entity("ZHcy", 0x0416);
		entity("zigrarr", 0x21DD);
		entity("zopf", 0x1D56B);
		entity("Zopf", 0x2124);
		entity("zscr", 0x1D4CF);
		entity("Zscr", 0x1D4B5);
		entity("zwj", 0x200D);
		entity("zwnj", 0x200C);

		// End of Schema calls
		}


	}
