/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.api;


import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

import java.util.List;

/**
 * An interface for creating ApiResponse instances.  To create an ApiResponseBuilder instance use
 * PaginatableResourceListBuilderFactory.getBuilder()
 */
@ProviderType
public interface PaginatableResourceListBuilder {
    /**
     * Set the next offset value.
     * @param value The value of the next offset.
     * @return This builder object.
     */
    PaginatableResourceListBuilder setNextOffsetValue(String value);

    /**
     * Set the count.
     * @param count The count.
     * @return This builder object.
     */
    PaginatableResourceListBuilder setCount(int count);

    /**
     * Set the list of resources.
     * @param resources The list of resources.
     * @return This builder object.
     */
    PaginatableResourceListBuilder setResources(List<Resource> resources);

    /**
     * Build the PaginatableResourceList.
     * @return The new PaginatableResourceList.
     */
    PaginatableResourceList build();
}
