/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.ui.clientlibs.script;

import java.io.IOException;
import java.io.Reader;

import javax.annotation.Nonnull;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Defines a script resource
 */
@ProviderType
public interface ScriptResource {

    /**
     * Gets the name (path) of the resource
     * @return the name
     */
    @Nonnull
    String getName();

    /**
     * Opens a reader to this resource
     * @return an open reader
     * @throws IOException if an error occurs
     */
    @Nonnull
    Reader getReader() throws IOException;

    /**
     * Returns the size of this resource
     * @return the size or -1 if not known
     */
    long getSize();

}