/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.workflow.exec;


import java.util.Map;

/**
 * Provides more context to script execution by the workflow engine
 */
public interface ScriptContextProvider {

    /**
     * called by WorkFlow script executiong methods with the parameters being provided to the scripting engine.  Implementers may peek at the values
     * in the Map and add more entries as appropriate.  It is not intended for the existing contents to be modified in any way, although it is not enforced
     * @param existingValues the values being passed to the script execution
     */
    void addContext(Map<String, Object> existingValues);

}
