/*
 * File: JCEHSMKeyHolder.java
 *  
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2007 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.credentials.impl;

import java.security.PrivateKey; 

import com.adobe.internal.pdftoolkit.core.credentials.PrivateKeyHolder;

/**
 * The JCEHSMKeyHolder contains the JCE PrivateKey and the Provider name.
 * Request from DSS - this will help their Java 5 PKCS11 prototype. 
 * @author mdharan
 *
 */
public class JCEKeyHolder implements PrivateKeyHolder
{
	PrivateKey jcePrivateKey;
	String providerName;

	

	public JCEKeyHolder(PrivateKey privateKey, String providerName) 
	{
		this.jcePrivateKey = privateKey;
		this.providerName = providerName;
	}

	public PrivateKey getJcePrivateKey() {
		return jcePrivateKey;
	}

	public void setJcePrivateKey(PrivateKey jcePrivateKey) {
		this.jcePrivateKey = jcePrivateKey;
	}

	public String getProviderName() {
		return providerName;
	}

	public void setProviderName(String providerName) {
		this.providerName = providerName;
	}
	
	public PrivateKeyHolder getPrivateKeyHolder() 
	{
		return this;
	}

	

}
