/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2009, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any. The           */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/

package com.adobe.versioncue.nativecomm.host;

import com.adobe.versioncue.nativecomm.ServiceAbortException;
import com.adobe.versioncue.nativecomm.msg.NCMap;

/**
 * @author  <a href="mailto:tnaroska@adobe.com">tnaroska</a>
 * @version $Revision$
 * @since   CS5
 */
public interface IRequest
{
	/** @return NativeService call name */
	String call();

	/**
	 * Returns the request parameters.
	 * 
	 * @return the request parameters
	 */
	NCMap params();

	/**
	 * Returns the results map.
	 * 
	 * @return the results map
	 */
	NCMap results();

	/**
	 * Returns the client initiating the request.
	 * 
	 * @return the client initiating the request
	 */
	IClient client();

	/**
	 * Returns true if the request was processed successfully.
	 * A request is considered not successful if either the fail() method was called or
	 * the {@link IHostDelegate#execute(IRequest)} method throws an exception.
	 * 
	 * @return true if the request was processed successfully
	 */
	boolean succeeded();

	/**
	 * Marks the request as failed. The reason code and error message are transmitted to ncomm
	 * client and will result in an ncomm exception on the client side.
	 * 
	 * @param reasonCode - error code
	 * @param errMessage - error message
	 */
	void fail(String reasonCode, String errMessage);

	/**
	 * Update progress information for this request [0.0 ... 1.0]
	 *
	 * @param taskname the task currently being performed
	 * @param progress the new progress value [0.0 ... 1.0]
	 * @throws ServiceAbortException if the request was aborted
	 */
	void setProgress(String taskname, double progress) throws ServiceAbortException;
}
