package com.adobe.xfa;


/**
 * A class to...
 *
 * @exclude from published api.
 */
public class Manifest extends ProtoableNode {

	public Manifest(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.MANIFEST, XFA.MANIFEST, null, XFA.MANIFESTTAG, XFA.MANIFEST);
	}
	
    /**
     * Computes the list of nodes that this manifest refers to.
     * @return the nodes referred to by this manifest.
     */
	public NodeList doEvaluate() {
		NodeList ret = new ArrayNodeList();

		Node child = getFirstXFAChild();
		int i = 0;
		while (child != null) {
			NodeList items = getItems(i);
			int nItems = items.length();
			for (int j = 0; j < nItems; j++) {
				Node oItem = (Node)items.item(j);
				assert(oItem instanceof Element);
				if (oItem instanceof Element) {
					Element oElement = (Element) oItem;
					ret.append(oElement);
				}
			}
			child = child.getNextXFASibling();
			i++;
		}
		return ret;
	}

	/*
     * Gets a list of NodeLists that the nIndex'th <ref> item resolves to.
	 * Useful subroutine to doEvalutate().
	 */
	NodeList getItems(int nIndex) {
		Node oChild = getXFAChild(nIndex);
		if (oChild.getClassTag() != XFA.REFTAG)
			return new ArrayNodeList(); // empty tree!
		TextNode oRef = (TextNode) oChild.getProperty(XFA.TEXTNODETAG, 0);
		String sRef = oRef.getValue();
		return getXFAParent().resolveNodes(sRef, true, false, false);
	}

	public ScriptTable getScriptTable() {
		return ManifestScript.getScriptTable();
	}
	
	/**
	 * Calls execValidate on nodes resulting from resolving all of the <ref> children of this manifest.
	 * @exclude from published api.
	 */ 	
	public boolean doExecValidate() {
		// overridden by FormManifest
		return false;
	}

	/**
	 * Calls execCalculate on nodes resulting from resolving all of the <ref> children of this manifest.
	 * @exclude from published api.
	 */
	public void doExecCalculate() {
		// overridden by FormManifest
	}
	
	/**
	 * Calls execInitialize on nodes resulting from resolving all of the <ref> children of this manifest.
	 * @exclude from published api.
	 */
	public void doExecInitialize() {
		// overridden by FormManifest
	}
}