/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.content;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;

/**
 * An element that creates a unit of data content representing a
 *              date conforming to a subset of ISO 8601 format.
 * 
 * date-data is PCDATA that obeys the following rules: the content must conform
 * to the date formats in the profile of [ISO8601] described in XFA
 * Specification "XFA Date and Time Formats" (see [XFA-DATETIME]). This profile
 * describes a useful subset of [ISO8601] that reduces complexity and potential
 * for error, while still conforming to the [ISO8601] standard. &copy; Copyright
 *
 * @exclude from published api.
 */
public final class DateValue extends Content {

	public DateValue(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.DATE, XFA.DATE, null, XFA.DATETAG,
				XFA.DATE);
	}

	public boolean equals(Object object) {
		
		if (this == object)
			return true;
		
		return super.equals(object) &&
			getValue().equals(((DateValue) object).getValue());
	}
	
	public int hashCode() {
		return super.hashCode() ^ getValue().hashCode();
	}

	/**
	 * Return the current date value as a String
	 * 
	 * @return the date value as a string.
	 */
	public String getValue() {
		return super.getStrValue();
	}

	public ScriptTable getScriptTable() {
		return DateScript.getScriptTable();
	}

	/**
	 * Set the current date value from a String
	 * 
	 * @param dateValue -
	 *            provided as a String
	 */
	public void setValue(String dateValue) {
		setStrValue(dateValue, true, false);
	}

	/**
	 * cast the current value to a String. This operator allows us to place an
	 * DateValueobject in any context which allows a String.
	 * 
	 * @return the date value as a String.
	 */
	public String toString() {
		return getValue();
	}

}
